/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.statistics.ColumnStatisticMetadata;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StatisticAggregationsDescriptor<T> {
    private final Map<String, T> grouping;
    private final Map<TableStatisticType, T> tableStatistics;
    private final List<ColumnStatisticsDescriptor<T>> columnStatistics;

    public static <T> StatisticAggregationsDescriptor<T> empty() {
        return StatisticAggregationsDescriptor.builder().build();
    }

    @JsonCreator
    public StatisticAggregationsDescriptor(@JsonProperty(value="grouping") Map<String, T> grouping, @JsonProperty(value="tableStatistics") Map<TableStatisticType, T> tableStatistics, @JsonProperty(value="columnStatistics") List<ColumnStatisticsDescriptor<T>> columnStatistics) {
        this.grouping = Collections.unmodifiableMap(new LinkedHashMap<String, T>(Objects.requireNonNull(grouping, "grouping is null")));
        this.tableStatistics = Collections.unmodifiableMap(new LinkedHashMap<TableStatisticType, T>(Objects.requireNonNull(tableStatistics, "tableStatistics is null")));
        this.columnStatistics = Objects.requireNonNull(columnStatistics, "columnStatistics is null");
    }

    public StatisticAggregationsDescriptor(Map<String, T> grouping, Map<TableStatisticType, T> tableStatistics, Map<ColumnStatisticMetadata, T> columnStatistics) {
        this(grouping, tableStatistics, Collections.unmodifiableList(columnStatistics.entrySet().stream().map((? super T e) -> new ColumnStatisticsDescriptor((ColumnStatisticMetadata)e.getKey(), e.getValue())).collect(Collectors.toList())));
    }

    @JsonProperty
    public Map<String, T> getGrouping() {
        return this.grouping;
    }

    @JsonProperty
    public Map<TableStatisticType, T> getTableStatistics() {
        return this.tableStatistics;
    }

    @JsonProperty
    public List<ColumnStatisticsDescriptor<T>> getColumnStatistics() {
        return this.columnStatistics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticAggregationsDescriptor that = (StatisticAggregationsDescriptor)o;
        return Objects.equals(this.grouping, that.grouping) && Objects.equals(this.tableStatistics, that.tableStatistics) && Objects.equals(this.columnStatistics, that.columnStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.grouping, this.tableStatistics, this.columnStatistics);
    }

    public String toString() {
        return String.format("%s {grouping=%s, tableStatistics=%s, columnStatistics=%s}", this.getClass().getSimpleName(), this.grouping, this.tableStatistics, this.columnStatistics);
    }

    public static <B> Builder<B> builder() {
        return new Builder();
    }

    public <T2> StatisticAggregationsDescriptor<T2> map(Function<T, T2> mapper) {
        LinkedHashMap newMap = new LinkedHashMap();
        this.getColumnStatistics().forEach(x -> {
            if (newMap.containsKey(x.getMetadata())) {
                throw new IllegalStateException(String.format("Duplicate key %s", x));
            }
            newMap.put(x.getMetadata(), x.getItem());
        });
        return new StatisticAggregationsDescriptor<T2>(StatisticAggregationsDescriptor.map(this.getGrouping(), mapper), StatisticAggregationsDescriptor.map(this.getTableStatistics(), mapper), StatisticAggregationsDescriptor.map(Collections.unmodifiableMap(newMap), mapper));
    }

    private static <K, V1, V2> Map<K, V2> map(Map<K, V1> input, Function<V1, V2> mapper) {
        return Collections.unmodifiableMap(input.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> mapper.apply(entry.getValue()), (e1, e2) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", e1));
        }, LinkedHashMap::new)));
    }

    public static class ColumnStatisticsDescriptor<T> {
        private final ColumnStatisticMetadata metadata;
        private final T item;

        @JsonCreator
        public ColumnStatisticsDescriptor(@JsonProperty(value="metadata") ColumnStatisticMetadata metadata, @JsonProperty(value="item") T item) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.item = Objects.requireNonNull(item, "item is null");
        }

        @JsonProperty
        public T getItem() {
            return this.item;
        }

        @JsonProperty
        public ColumnStatisticMetadata getMetadata() {
            return this.metadata;
        }

        public int hashCode() {
            return Objects.hash(this.metadata, this.item);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ColumnStatisticsDescriptor)) {
                return false;
            }
            ColumnStatisticsDescriptor other = (ColumnStatisticsDescriptor)o;
            return this.metadata.equals(other.metadata) && this.item.equals(other.item);
        }

        public String toString() {
            return String.format("%s {metadata=%s, item=%s}", this.getClass().getSimpleName(), this.metadata, this.item);
        }
    }

    public static class Builder<T> {
        private final Map<String, T> grouping = new LinkedHashMap<String, T>();
        private final Map<TableStatisticType, T> tableStatistics = new LinkedHashMap<TableStatisticType, T>();
        private final Map<ColumnStatisticMetadata, T> columnStatistics = new LinkedHashMap<ColumnStatisticMetadata, T>();

        public void addGrouping(String column, T key) {
            this.grouping.put(column, key);
        }

        public void addTableStatistic(TableStatisticType type, T key) {
            this.tableStatistics.put(type, key);
        }

        public void addColumnStatistic(ColumnStatisticMetadata statisticMetadata, T key) {
            this.columnStatistics.put(statisticMetadata, key);
        }

        public StatisticAggregationsDescriptor<T> build() {
            return new StatisticAggregationsDescriptor<T>(Collections.unmodifiableMap(this.grouping), Collections.unmodifiableMap(this.tableStatistics), Collections.unmodifiableMap(this.columnStatistics));
        }
    }
}

