/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.common.Utils;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.CteMaterializationInfo;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.StatisticAggregations;
import com.facebook.presto.spi.plan.StatisticAggregationsDescriptor;
import com.facebook.presto.spi.plan.TableWriterNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TableFinishNode
extends PlanNode {
    private final PlanNode source;
    private final Optional<TableWriterNode.WriterTarget> target;
    private final VariableReferenceExpression rowCountVariable;
    private final Optional<StatisticAggregations> statisticsAggregation;
    private final Optional<StatisticAggregationsDescriptor<VariableReferenceExpression>> statisticsAggregationDescriptor;
    private final Optional<CteMaterializationInfo> temporaryTableInfo;

    @JsonCreator
    public TableFinishNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") Optional<TableWriterNode.WriterTarget> target, @JsonProperty(value="rowCountVariable") VariableReferenceExpression rowCountVariable, @JsonProperty(value="statisticsAggregation") Optional<StatisticAggregations> statisticsAggregation, @JsonProperty(value="statisticsAggregationDescriptor") Optional<StatisticAggregationsDescriptor<VariableReferenceExpression>> statisticsAggregationDescriptor, @JsonProperty(value="cteMaterializationInfo") Optional<CteMaterializationInfo> temporaryTableInfo) {
        this(sourceLocation, id, Optional.empty(), source, target, rowCountVariable, statisticsAggregation, statisticsAggregationDescriptor, temporaryTableInfo);
    }

    public TableFinishNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, Optional<TableWriterNode.WriterTarget> target, VariableReferenceExpression rowCountVariable, Optional<StatisticAggregations> statisticsAggregation, Optional<StatisticAggregationsDescriptor<VariableReferenceExpression>> statisticsAggregationDescriptor, Optional<CteMaterializationInfo> temporaryTableInfo) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        Utils.checkArgument((target != null || source instanceof TableWriterNode ? 1 : 0) != 0);
        this.temporaryTableInfo = temporaryTableInfo;
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowCountVariable = Objects.requireNonNull(rowCountVariable, "rowCountVariable is null");
        this.statisticsAggregation = Objects.requireNonNull(statisticsAggregation, "statisticsAggregation is null");
        this.statisticsAggregationDescriptor = Objects.requireNonNull(statisticsAggregationDescriptor, "statisticsAggregationDescriptor is null");
        Utils.checkArgument((statisticsAggregation.isPresent() == statisticsAggregationDescriptor.isPresent() ? 1 : 0) != 0, (String)"statisticsAggregation and statisticsAggregationDescriptor must both be either present or absent", (Object[])new Object[0]);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonIgnore
    public Optional<TableWriterNode.WriterTarget> getTarget() {
        return this.target;
    }

    @JsonProperty
    public VariableReferenceExpression getRowCountVariable() {
        return this.rowCountVariable;
    }

    @JsonProperty
    public Optional<StatisticAggregations> getStatisticsAggregation() {
        return this.statisticsAggregation;
    }

    @JsonProperty
    public Optional<StatisticAggregationsDescriptor<VariableReferenceExpression>> getStatisticsAggregationDescriptor() {
        return this.statisticsAggregationDescriptor;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return Collections.singletonList(this.rowCountVariable);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableFinish(this, context);
    }

    public Optional<CteMaterializationInfo> getCteMaterializationInfo() {
        return this.temporaryTableInfo;
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Utils.checkArgument((newChildren.size() == 1 ? 1 : 0) != 0);
        return new TableFinishNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.target, this.rowCountVariable, this.statisticsAggregation, this.statisticsAggregationDescriptor, this.temporaryTableInfo);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new TableFinishNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.target, this.rowCountVariable, this.statisticsAggregation, this.statisticsAggregationDescriptor, this.temporaryTableInfo);
    }
}

