/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.plan.CteMaterializationInfo;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TableScanNode
extends PlanNode {
    private final TableHandle table;
    private final Map<VariableReferenceExpression, ColumnHandle> assignments;
    private final List<VariableReferenceExpression> outputVariables;
    private final TupleDomain<ColumnHandle> currentConstraint;
    private final TupleDomain<ColumnHandle> enforcedConstraint;
    private final List<TableConstraint<ColumnHandle>> tableConstraints;
    private final Optional<CteMaterializationInfo> cteMaterializationInfo;

    @JsonCreator
    public TableScanNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") TableHandle table, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="assignments") Map<VariableReferenceExpression, ColumnHandle> assignments) {
        super(sourceLocation, id, Optional.empty());
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputVariables = Collections.unmodifiableList(Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.assignments = Collections.unmodifiableMap(new HashMap<VariableReferenceExpression, ColumnHandle>(Objects.requireNonNull(assignments, "assignments is null")));
        TableScanNode.checkArgument(assignments.keySet().containsAll(outputVariables), "assignments does not cover all of outputs");
        this.currentConstraint = null;
        this.enforcedConstraint = null;
        this.tableConstraints = Collections.emptyList();
        this.cteMaterializationInfo = Optional.empty();
    }

    public TableScanNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, TableHandle table, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnHandle> assignments, TupleDomain<ColumnHandle> currentConstraint, TupleDomain<ColumnHandle> enforcedConstraint, Optional<CteMaterializationInfo> cteMaterializationInfo) {
        this(sourceLocation, id, table, outputVariables, assignments, Collections.emptyList(), currentConstraint, enforcedConstraint, cteMaterializationInfo);
    }

    public TableScanNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, TableHandle table, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnHandle> assignments, List<TableConstraint<ColumnHandle>> tableConstraints, TupleDomain<ColumnHandle> currentConstraint, TupleDomain<ColumnHandle> enforcedConstraint, Optional<CteMaterializationInfo> cteMaterializationInfo) {
        this(sourceLocation, id, Optional.empty(), table, outputVariables, assignments, tableConstraints, currentConstraint, enforcedConstraint, cteMaterializationInfo);
    }

    public TableScanNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, TableHandle table, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnHandle> assignments, List<TableConstraint<ColumnHandle>> tableConstraints, TupleDomain<ColumnHandle> currentConstraint, TupleDomain<ColumnHandle> enforcedConstraint, Optional<CteMaterializationInfo> cteMaterializationInfo) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputVariables = Collections.unmodifiableList(Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.assignments = Collections.unmodifiableMap(new HashMap<VariableReferenceExpression, ColumnHandle>(Objects.requireNonNull(assignments, "assignments is null")));
        this.cteMaterializationInfo = Objects.requireNonNull(cteMaterializationInfo, "cteMaterializationInfo is null");
        TableScanNode.checkArgument(assignments.keySet().containsAll(outputVariables), "assignments does not cover all of outputs");
        this.currentConstraint = Objects.requireNonNull(currentConstraint, "currentConstraint is null");
        this.enforcedConstraint = Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        if (!currentConstraint.isAll() || !enforcedConstraint.isAll()) {
            TableScanNode.checkArgument(table.getLayout().isPresent(), "tableLayout must be present when currentConstraint or enforcedConstraint is non-trivial");
        }
        this.tableConstraints = Objects.requireNonNull(tableConstraints, "tableConstraints is null");
    }

    public Optional<CteMaterializationInfo> getCteMaterializationInfo() {
        return this.cteMaterializationInfo;
    }

    @JsonProperty(value="table")
    public TableHandle getTable() {
        return this.table;
    }

    public List<TableConstraint<ColumnHandle>> getTableConstraints() {
        return this.tableConstraints;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @Nullable
    public TupleDomain<ColumnHandle> getCurrentConstraint() {
        return this.currentConstraint;
    }

    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        TableScanNode.checkState(this.enforcedConstraint != null, "enforcedConstraint should only be used in planner. It is not transported to workers.");
        return this.enforcedConstraint;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.emptyList();
    }

    @Override
    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getTableScanProperties(this);
    }

    @Override
    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableScan(this, context);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new TableScanNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.table, this.outputVariables, this.assignments, this.tableConstraints, this.currentConstraint, this.enforcedConstraint, this.cteMaterializationInfo);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append(" {");
        stringBuilder.append("table='").append(this.table).append('\'');
        stringBuilder.append(", outputVariables='").append(this.outputVariables).append('\'');
        stringBuilder.append(", assignments='").append(this.assignments).append('\'');
        stringBuilder.append(", currentConstraint='").append(this.currentConstraint).append('\'');
        stringBuilder.append(", enforcedConstraint='").append(this.enforcedConstraint).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        TableScanNode.checkArgument(newChildren.isEmpty(), "newChildren is not empty");
        return this;
    }

    private static void checkArgument(boolean test, String errorMessage) {
        if (!test) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static void checkState(boolean test, String errorMessage) {
        if (!test) {
            throw new IllegalStateException(errorMessage);
        }
    }
}

