/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.statistics;

import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.facebook.presto.spi.statistics.Estimate;

public class HistogramCalculator {
    private HistogramCalculator() {
    }

    public static Estimate calculateFilterFactor(Range range, double rangeDistinctValues, ConnectorHistogram histogram, Estimate totalDistinctValues, boolean useHeuristics) {
        boolean openHigh = !range.isHighInclusive();
        boolean openLow = !range.isLowInclusive();
        Estimate min = histogram.inverseCumulativeProbability(0.0);
        Estimate max = histogram.inverseCumulativeProbability(1.0);
        double rangeLow = range.getLowValue().map(Double.class::cast).orElse(Double.NEGATIVE_INFINITY);
        double rangeHigh = range.getHighValue().map(Double.class::cast).orElse(Double.POSITIVE_INFINITY);
        double rangeLength = rangeHigh - rangeLow;
        if (!max.isUnknown() && (!openHigh ? max.getValue() < rangeLow : max.getValue() <= rangeLow) || !min.isUnknown() && (openLow ? min.getValue() >= rangeHigh : min.getValue() > rangeHigh)) {
            return Estimate.of(0.0);
        }
        if (max.isUnknown() && !min.isUnknown() || !max.isUnknown() && min.isUnknown()) {
            if (!useHeuristics) {
                return Estimate.unknown();
            }
            if (rangeLength == 0.0) {
                return totalDistinctValues.map(distinct -> 1.0 / distinct);
            }
            if (Double.isFinite(rangeLength)) {
                return Estimate.of(0.25);
            }
            return Estimate.of(0.5);
        }
        Estimate lowPercentile = histogram.cumulativeProbability(rangeLow, openLow);
        Estimate highPercentile = histogram.cumulativeProbability(rangeHigh, !openHigh);
        if (lowPercentile.isUnknown() || highPercentile.isUnknown()) {
            if (!useHeuristics) {
                return Estimate.unknown();
            }
            if (totalDistinctValues.equals(Estimate.zero()) || rangeDistinctValues == 0.0) {
                return Estimate.of(0.0);
            }
            if ((lowPercentile.isUnknown() && !highPercentile.isUnknown() || !lowPercentile.isUnknown() && highPercentile.isUnknown()) && Double.isFinite(rangeLength)) {
                return Estimate.of(0.25);
            }
            if (rangeLength == 0.0) {
                return totalDistinctValues.map(distinct -> 1.0 / distinct);
            }
            if (!Double.isNaN(rangeDistinctValues)) {
                return totalDistinctValues.map(distinct -> Math.min(1.0, rangeDistinctValues / distinct));
            }
            return Estimate.of(0.5);
        }
        if (lowPercentile.equals(highPercentile)) {
            if (!useHeuristics) {
                return Estimate.zero();
            }
            return totalDistinctValues.map(distinct -> 1.0 / distinct);
        }
        if (lowPercentile.equals(Estimate.zero()) && highPercentile.equals(Estimate.of(1.0)) && min.isUnknown() && max.isUnknown()) {
            if (!useHeuristics) {
                return Estimate.unknown();
            }
            return totalDistinctValues.flatMap(totalDistinct -> {
                if (HistogramCalculator.fuzzyEquals(totalDistinct, 0.0, 1.0E-6)) {
                    return Estimate.of(1.0);
                }
                return Estimate.of(Math.min(1.0, rangeDistinctValues / totalDistinct));
            }).or(() -> Estimate.of(0.5));
        }
        return lowPercentile.flatMap(lowPercent -> highPercentile.map(highPercent -> highPercent - lowPercent));
    }

    private static boolean fuzzyEquals(double a, double b, double tolerance) {
        return Math.copySign(a - b, 1.0) <= tolerance || a == b || Double.isNaN(a) && Double.isNaN(b);
    }
}

