/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.util.Set;

public interface NodeManager {
    public Set<Node> getAllNodes();

    public Set<Node> getWorkerNodes();

    public Node getCurrentNode();

    public Node getSidecarNode();

    public String getEnvironment();

    default public Set<Node> getRequiredWorkerNodes() {
        Set<Node> nodes = this.getWorkerNodes();
        if (nodes.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
        }
        return nodes;
    }
}

