/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.connector.classloader;

import com.facebook.presto.spi.ConnectorDeleteTableHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSinkContext;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorPageSink;
import java.util.Objects;

public final class ClassLoaderSafeConnectorPageSinkProvider
implements ConnectorPageSinkProvider {
    private final ConnectorPageSinkProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorPageSinkProvider(ConnectorPageSinkProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, PageSinkContext pageSinkContext) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorPageSink classLoaderSafeConnectorPageSink = new ClassLoaderSafeConnectorPageSink(this.delegate.createPageSink(transactionHandle, session, outputTableHandle, pageSinkContext), this.classLoader);
            return classLoaderSafeConnectorPageSink;
        }
    }

    @Override
    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, PageSinkContext pageSinkContext) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorPageSink classLoaderSafeConnectorPageSink = new ClassLoaderSafeConnectorPageSink(this.delegate.createPageSink(transactionHandle, session, insertTableHandle, pageSinkContext), this.classLoader);
            return classLoaderSafeConnectorPageSink;
        }
    }

    @Override
    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorDeleteTableHandle deleteTableHandle, PageSinkContext pageSinkContext) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorPageSink classLoaderSafeConnectorPageSink = new ClassLoaderSafeConnectorPageSink(this.delegate.createPageSink(transactionHandle, session, deleteTableHandle, pageSinkContext), this.classLoader);
            return classLoaderSafeConnectorPageSink;
        }
    }
}

