/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.function;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeSignature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ThriftStruct
public class SqlFunctionId {
    private final QualifiedObjectName functionName;
    private final List<TypeSignature> argumentTypes;

    @ThriftConstructor
    public SqlFunctionId(String signature) {
        this(SqlFunctionId.parseSqlFunctionId(signature).getFunctionName(), SqlFunctionId.parseSqlFunctionId(signature).getArgumentTypes());
    }

    public SqlFunctionId(QualifiedObjectName functionName, List<TypeSignature> argumentTypes) {
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.argumentTypes = Objects.requireNonNull(argumentTypes, "argumentTypes is null");
    }

    public QualifiedObjectName getFunctionName() {
        return this.functionName;
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    public String getId() {
        return this.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlFunctionId o = (SqlFunctionId)obj;
        return Objects.equals(this.functionName, o.functionName) && Objects.equals(this.argumentTypes, o.argumentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.functionName, this.argumentTypes);
    }

    public String toString() {
        String arguments = this.argumentTypes.stream().map(Object::toString).collect(Collectors.joining(", "));
        return String.format("%s(%s)", this.functionName, arguments);
    }

    @JsonValue
    @ThriftField(value=1, name="signature")
    public String toJsonString() {
        return String.format("%s;%s", this.functionName.toString(), this.argumentTypes.stream().map(TypeSignature::toString).collect(Collectors.joining(";")));
    }

    @JsonCreator
    public static SqlFunctionId parseSqlFunctionId(String signature) {
        String[] parts = signature.split(";");
        if (parts.length == 1) {
            return new SqlFunctionId(QualifiedObjectName.valueOf((String)parts[0]), Collections.emptyList());
        }
        if (parts.length > 1) {
            QualifiedObjectName name = QualifiedObjectName.valueOf((String)parts[0]);
            List<TypeSignature> argumentTypes = Arrays.stream(parts, 1, parts.length).map(TypeSignature::parseTypeSignature).collect(Collectors.toList());
            return new SqlFunctionId(name, argumentTypes);
        }
        throw new AssertionError((Object)String.format("Invalid serialization: %s", signature));
    }
}

