/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.common.Utils;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.AbstractJoinNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinDistributionType;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JoinNode
extends AbstractJoinNode {
    private final JoinType type;
    private final PlanNode left;
    private final PlanNode right;
    private final List<EquiJoinClause> criteria;
    private final List<VariableReferenceExpression> outputVariables;
    private final Optional<RowExpression> filter;
    private final Optional<VariableReferenceExpression> leftHashVariable;
    private final Optional<VariableReferenceExpression> rightHashVariable;
    private final Optional<JoinDistributionType> distributionType;
    private final Map<String, VariableReferenceExpression> dynamicFilters;

    @JsonCreator
    public JoinNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") JoinType type, @JsonProperty(value="left") PlanNode left, @JsonProperty(value="right") PlanNode right, @JsonProperty(value="criteria") List<EquiJoinClause> criteria, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="filter") Optional<RowExpression> filter, @JsonProperty(value="leftHashVariable") Optional<VariableReferenceExpression> leftHashVariable, @JsonProperty(value="rightHashVariable") Optional<VariableReferenceExpression> rightHashVariable, @JsonProperty(value="distributionType") Optional<JoinDistributionType> distributionType, @JsonProperty(value="dynamicFilters") Map<String, VariableReferenceExpression> dynamicFilters) {
        this(sourceLocation, id, Optional.empty(), type, left, right, criteria, outputVariables, filter, leftHashVariable, rightHashVariable, distributionType, dynamicFilters);
    }

    public JoinNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, JoinType type, PlanNode left, PlanNode right, List<EquiJoinClause> criteria, List<VariableReferenceExpression> outputVariables, Optional<RowExpression> filter, Optional<VariableReferenceExpression> leftHashVariable, Optional<VariableReferenceExpression> rightHashVariable, Optional<JoinDistributionType> distributionType, Map<String, VariableReferenceExpression> dynamicFilters) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        Objects.requireNonNull(criteria, "criteria is null");
        Objects.requireNonNull(outputVariables, "outputVariables is null");
        Objects.requireNonNull(filter, "filter is null");
        Objects.requireNonNull(leftHashVariable, "leftHashVariable is null");
        Objects.requireNonNull(rightHashVariable, "rightHashVariable is null");
        Objects.requireNonNull(distributionType, "distributionType is null");
        Objects.requireNonNull(dynamicFilters, "dynamicFilters is null");
        this.type = type;
        this.left = left;
        this.right = right;
        this.criteria = Collections.unmodifiableList(new ArrayList<EquiJoinClause>(criteria));
        this.outputVariables = Collections.unmodifiableList(new ArrayList<VariableReferenceExpression>(outputVariables));
        this.filter = filter;
        this.leftHashVariable = leftHashVariable;
        this.rightHashVariable = rightHashVariable;
        this.distributionType = distributionType;
        this.dynamicFilters = Collections.unmodifiableMap(new LinkedHashMap<String, VariableReferenceExpression>(dynamicFilters));
        JoinNode.checkLeftOutputVariablesBeforeRight(left.getOutputVariables(), outputVariables);
        HashSet<VariableReferenceExpression> inputVariables = new HashSet<VariableReferenceExpression>();
        inputVariables.addAll(left.getOutputVariables());
        inputVariables.addAll(right.getOutputVariables());
        Utils.checkArgument((boolean)inputVariables.containsAll(outputVariables), (String)"Left and right join inputs do not contain all output variables", (Object[])new Object[0]);
        Utils.checkArgument((!this.isCrossJoin() || inputVariables.size() == outputVariables.size() ? 1 : 0) != 0, (String)"Cross join does not support output variables pruning or reordering", (Object[])new Object[0]);
        Utils.checkArgument((!criteria.isEmpty() || !leftHashVariable.isPresent() ? 1 : 0) != 0, (String)"Left hash variable is only valid in an equijoin", (Object[])new Object[0]);
        Utils.checkArgument((!criteria.isEmpty() || !rightHashVariable.isPresent() ? 1 : 0) != 0, (String)"Right hash variable is only valid in an equijoin", (Object[])new Object[0]);
        if (distributionType.isPresent()) {
            Utils.checkArgument((distributionType.get() != JoinDistributionType.REPLICATED || !type.mustPartition() ? 1 : 0) != 0, (String)String.format("%s join do not work with %s distribution type", new Object[]{type, distributionType.get()}), (Object[])new Object[0]);
            Utils.checkArgument((distributionType.get() != JoinDistributionType.PARTITIONED || !type.mustReplicate(criteria) ? 1 : 0) != 0, (String)String.format("Equi criteria are empty, so %s join should not have %s distribution type", new Object[]{type, distributionType.get()}), (Object[])new Object[0]);
        }
        for (VariableReferenceExpression variableReferenceExpression : dynamicFilters.values()) {
            Utils.checkArgument((boolean)right.getOutputVariables().contains(variableReferenceExpression), (String)String.format("Right join input doesn't contain symbol for dynamic filter: %s, rightVariables: %s, dynamicFilters.values(): %s", variableReferenceExpression, Arrays.toString(right.getOutputVariables().toArray()), Arrays.toString(dynamicFilters.values().toArray())), (Object[])new Object[0]);
        }
    }

    public static void checkLeftOutputVariablesBeforeRight(List<VariableReferenceExpression> leftVariables, List<VariableReferenceExpression> outputVariables) {
        int leftMaxPosition = -1;
        Optional<Object> rightMinPosition = Optional.empty();
        HashSet<VariableReferenceExpression> leftVariablesSet = new HashSet<VariableReferenceExpression>(leftVariables);
        for (int i = 0; i < outputVariables.size(); ++i) {
            VariableReferenceExpression variable = outputVariables.get(i);
            if (leftVariablesSet.contains(variable)) {
                leftMaxPosition = i;
                continue;
            }
            if (rightMinPosition.isPresent()) continue;
            rightMinPosition = Optional.of(i);
        }
        Utils.checkState((!rightMinPosition.isPresent() || (Integer)rightMinPosition.get() > leftMaxPosition ? 1 : 0) != 0, (String)"Not all left output variables are before right output variables");
    }

    public JoinNode flipChildren() {
        return new JoinNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), JoinNode.flipType(this.type), this.right, this.left, JoinNode.flipJoinCriteria(this.criteria), JoinNode.flipOutputVariables(this.getOutputVariables(), this.left, this.right), this.filter, this.rightHashVariable, this.leftHashVariable, this.distributionType, Collections.emptyMap());
    }

    public static JoinType flipType(JoinType type) {
        switch (type) {
            case INNER: {
                return JoinType.INNER;
            }
            case FULL: {
                return JoinType.FULL;
            }
            case LEFT: {
                return JoinType.RIGHT;
            }
            case RIGHT: {
                return JoinType.LEFT;
            }
        }
        throw new IllegalStateException("No inverse defined for join type: " + (Object)((Object)type));
    }

    private static List<EquiJoinClause> flipJoinCriteria(List<EquiJoinClause> joinCriteria) {
        List flippedCriteria = joinCriteria.stream().map(EquiJoinClause::flip).collect(Collectors.toList());
        return Collections.unmodifiableList(flippedCriteria);
    }

    private static List<VariableReferenceExpression> flipOutputVariables(List<VariableReferenceExpression> outputVariables, PlanNode left, PlanNode right) {
        List leftVariables = outputVariables.stream().filter(variable -> left.getOutputVariables().contains(variable)).collect(Collectors.toList());
        List rightVariables = outputVariables.stream().filter(variable -> right.getOutputVariables().contains(variable)).collect(Collectors.toList());
        ArrayList flippedOutput = new ArrayList(rightVariables);
        flippedOutput.addAll(leftVariables);
        return Collections.unmodifiableList(flippedOutput);
    }

    @JsonProperty
    public JoinType getType() {
        return this.type;
    }

    @JsonProperty
    public PlanNode getLeft() {
        return this.left;
    }

    @Override
    public PlanNode getProbe() {
        return this.left;
    }

    @JsonProperty
    public PlanNode getRight() {
        return this.right;
    }

    @Override
    public PlanNode getBuild() {
        return this.right;
    }

    @JsonProperty
    public List<EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    @JsonProperty
    public Optional<RowExpression> getFilter() {
        return this.filter;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getLeftHashVariable() {
        return this.leftHashVariable;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getRightHashVariable() {
        return this.rightHashVariable;
    }

    @Override
    public List<PlanNode> getSources() {
        ArrayList<PlanNode> sources = new ArrayList<PlanNode>();
        sources.add(this.left);
        sources.add(this.right);
        return Collections.unmodifiableList(sources);
    }

    @Override
    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getJoinProperties(this);
    }

    @Override
    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public Optional<JoinDistributionType> getDistributionType() {
        return this.distributionType;
    }

    @Override
    @JsonProperty
    public Map<String, VariableReferenceExpression> getDynamicFilters() {
        return this.dynamicFilters;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Utils.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (String)"expected newChildren to contain 2 nodes", (Object[])new Object[0]);
        return new JoinNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), this.type, newChildren.get(0), newChildren.get(1), this.criteria, this.outputVariables, this.filter, this.leftHashVariable, this.rightHashVariable, this.distributionType, this.dynamicFilters);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new JoinNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.type, this.left, this.right, this.criteria, this.outputVariables, this.filter, this.leftHashVariable, this.rightHashVariable, this.distributionType, this.dynamicFilters);
    }

    public JoinNode withDistributionType(JoinDistributionType distributionType) {
        return new JoinNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), this.type, this.left, this.right, this.criteria, this.outputVariables, this.filter, this.leftHashVariable, this.rightHashVariable, Optional.of(distributionType), this.dynamicFilters);
    }

    public boolean isCrossJoin() {
        return this.criteria.isEmpty() && !this.filter.isPresent() && this.type == JoinType.INNER;
    }
}

