/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.relation.IntermediateFormExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class InSubqueryExpression
extends IntermediateFormExpression {
    private final VariableReferenceExpression value;
    private final VariableReferenceExpression subquery;

    public InSubqueryExpression(Optional<SourceLocation> sourceLocation, VariableReferenceExpression value, VariableReferenceExpression subquery) {
        super(sourceLocation);
        this.value = Objects.requireNonNull(value, "value is null");
        this.subquery = Objects.requireNonNull(subquery, "subquery is null");
    }

    public VariableReferenceExpression getValue() {
        return this.value;
    }

    public VariableReferenceExpression getSubquery() {
        return this.subquery;
    }

    @Override
    public Type getType() {
        return BooleanType.BOOLEAN;
    }

    @Override
    public List<RowExpression> getChildren() {
        return Collections.unmodifiableList(Arrays.asList(this.value, this.subquery));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InSubqueryExpression other = (InSubqueryExpression)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.subquery, other.subquery);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.subquery);
    }

    @Override
    public String toString() {
        return String.format("%s IN %s", this.value, this.subquery);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitInSubqueryExpression(this, context);
    }

    @Override
    public RowExpression canonicalize() {
        return this.getSourceLocation().isPresent() ? new InSubqueryExpression(Optional.empty(), this.value, this.subquery) : this;
    }
}

