/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.security;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AuthorizedIdentity;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.ViewExpression;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface AccessControl {
    public void checkCanSetUser(Identity var1, AccessControlContext var2, Optional<Principal> var3, String var4);

    default public AuthorizedIdentity selectAuthorizedIdentity(Identity identity, AccessControlContext accessControlContext, String userName, List<X509Certificate> certificates) {
        return new AuthorizedIdentity(userName, "", true);
    }

    public void checkQueryIntegrity(Identity var1, AccessControlContext var2, String var3, Map<QualifiedObjectName, ViewDefinition> var4, Map<QualifiedObjectName, MaterializedViewDefinition> var5);

    public Set<String> filterCatalogs(Identity var1, AccessControlContext var2, Set<String> var3);

    public void checkCanAccessCatalog(Identity var1, AccessControlContext var2, String var3);

    public void checkCanCreateSchema(TransactionId var1, Identity var2, AccessControlContext var3, CatalogSchemaName var4);

    public void checkCanDropSchema(TransactionId var1, Identity var2, AccessControlContext var3, CatalogSchemaName var4);

    public void checkCanRenameSchema(TransactionId var1, Identity var2, AccessControlContext var3, CatalogSchemaName var4, String var5);

    public void checkCanShowSchemas(TransactionId var1, Identity var2, AccessControlContext var3, String var4);

    public Set<String> filterSchemas(TransactionId var1, Identity var2, AccessControlContext var3, String var4, Set<String> var5);

    public void checkCanCreateTable(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanDropTable(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanRenameTable(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4, QualifiedObjectName var5);

    public void checkCanSetTableProperties(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4, Map<String, Object> var5);

    public void checkCanShowTablesMetadata(TransactionId var1, Identity var2, AccessControlContext var3, CatalogSchemaName var4);

    public Set<SchemaTableName> filterTables(TransactionId var1, Identity var2, AccessControlContext var3, String var4, Set<SchemaTableName> var5);

    public void checkCanAddColumns(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanDropColumn(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanRenameColumn(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanInsertIntoTable(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanDeleteFromTable(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanTruncateTable(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanUpdateTableColumns(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4, Set<String> var5);

    public void checkCanCreateView(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanRenameView(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4, QualifiedObjectName var5);

    public void checkCanDropView(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanCreateViewWithSelectFromColumns(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4, Set<String> var5);

    public void checkCanGrantTablePrivilege(TransactionId var1, Identity var2, AccessControlContext var3, Privilege var4, QualifiedObjectName var5, PrestoPrincipal var6, boolean var7);

    public void checkCanRevokeTablePrivilege(TransactionId var1, Identity var2, AccessControlContext var3, Privilege var4, QualifiedObjectName var5, PrestoPrincipal var6, boolean var7);

    public void checkCanSetSystemSessionProperty(Identity var1, AccessControlContext var2, String var3);

    public void checkCanSetCatalogSessionProperty(TransactionId var1, Identity var2, AccessControlContext var3, String var4, String var5);

    public void checkCanSelectFromColumns(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4, Set<Subfield> var5);

    public void checkCanCreateRole(TransactionId var1, Identity var2, AccessControlContext var3, String var4, Optional<PrestoPrincipal> var5, String var6);

    public void checkCanDropRole(TransactionId var1, Identity var2, AccessControlContext var3, String var4, String var5);

    public void checkCanGrantRoles(TransactionId var1, Identity var2, AccessControlContext var3, Set<String> var4, Set<PrestoPrincipal> var5, boolean var6, Optional<PrestoPrincipal> var7, String var8);

    public void checkCanRevokeRoles(TransactionId var1, Identity var2, AccessControlContext var3, Set<String> var4, Set<PrestoPrincipal> var5, boolean var6, Optional<PrestoPrincipal> var7, String var8);

    public void checkCanSetRole(TransactionId var1, Identity var2, AccessControlContext var3, String var4, String var5);

    public void checkCanShowRoles(TransactionId var1, Identity var2, AccessControlContext var3, String var4);

    public void checkCanShowCurrentRoles(TransactionId var1, Identity var2, AccessControlContext var3, String var4);

    public void checkCanShowRoleGrants(TransactionId var1, Identity var2, AccessControlContext var3, String var4);

    public void checkCanDropConstraint(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanAddConstraints(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    default public List<ViewExpression> getRowFilters(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        return Collections.emptyList();
    }

    default public Map<ColumnMetadata, ViewExpression> getColumnMasks(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, List<ColumnMetadata> columns) {
        return Collections.emptyMap();
    }
}

