/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class AuthorizedIdentity {
    private final String userName;
    private final Optional<String> reasonForSelect;
    private final Optional<Boolean> delegationCheckResult;

    @JsonCreator
    public AuthorizedIdentity(@JsonProperty(value="userName") String userName, @JsonProperty(value="reasonForSelect") String reasonForSelect, @JsonProperty(value="delegationCheckResult") Boolean delegationCheckResult) {
        this.userName = Objects.requireNonNull(userName, "userName is null");
        this.reasonForSelect = Optional.ofNullable(reasonForSelect);
        this.delegationCheckResult = Optional.ofNullable(delegationCheckResult);
    }

    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    public Optional<String> getReasonForSelect() {
        return this.reasonForSelect;
    }

    @JsonProperty(value="reasonForSelect")
    public String getReasonForSelectValue() {
        return this.reasonForSelect.orElse(null);
    }

    public Optional<Boolean> getDelegationCheckResult() {
        return this.delegationCheckResult;
    }

    @JsonProperty(value="delegationCheckResult")
    public Boolean getDelegationCheckResultValue() {
        return this.delegationCheckResult.orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizedIdentity that = (AuthorizedIdentity)o;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.reasonForSelect, that.reasonForSelect) && Objects.equals(this.delegationCheckResult, that.delegationCheckResult);
    }

    public int hashCode() {
        return Objects.hash(this.userName, this.reasonForSelect, this.delegationCheckResult);
    }
}

