/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;

public abstract class AbstractType
implements Type {
    private final String name;
    private final Class<?> javaType;

    protected AbstractType(String name, Class<?> javaType) {
        this.name = name;
        this.javaType = javaType;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public boolean isComparable() {
        return false;
    }

    @Override
    public boolean isOrderable() {
        return false;
    }

    @Override
    public int hash(Block block, int position) {
        throw new UnsupportedOperationException(this.getName() + " type is not comparable");
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException(this.getName() + " type is not comparable");
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException(this.getName() + " type is not ordered");
    }

    @Override
    public boolean getBoolean(Block block, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(Block block, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(Block block, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeDouble(BlockBuilder blockBuilder, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getSlice(Block block, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    public final String toString() {
        return this.getName();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }
}

