/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.teradata.functions;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.FunctionDependency;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class TeradataStringFunctions {
    private TeradataStringFunctions() {
    }

    @Description(value="Returns index of first occurrence of a substring (or 0 if not found)")
    @ScalarFunction(value="index")
    @SqlType(value="bigint")
    public static long index(@FunctionDependency(name="strpos", returnType="bigint", argumentTypes={"varchar", "varchar"}) MethodHandle method, @SqlType(value="varchar") Slice string, @SqlType(value="varchar") Slice substring) {
        try {
            return method.invokeExact(string, substring);
        }
        catch (Throwable t) {
            Throwables.throwIfInstanceOf((Throwable)t, Error.class);
            Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
        }
    }

    @Description(value="suffix starting at given index")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice substring(@FunctionDependency(name="substr", returnType="varchar(x)", argumentTypes={"varchar(x)", "bigint"}) MethodHandle method, @SqlType(value="varchar(x)") Slice utf8, @SqlType(value="bigint") long start) {
        try {
            return method.invokeExact(utf8, start);
        }
        catch (Throwable t) {
            Throwables.throwIfInstanceOf((Throwable)t, Error.class);
            Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
        }
    }

    @Description(value="substring of given length starting at an index")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice substring(@FunctionDependency(name="substr", returnType="varchar(x)", argumentTypes={"varchar(x)", "bigint", "bigint"}) MethodHandle method, @SqlType(value="varchar(x)") Slice utf8, @SqlType(value="bigint") long start, @SqlType(value="bigint") long length) {
        try {
            return method.invokeExact(utf8, start, length);
        }
        catch (Throwable t) {
            Throwables.throwIfInstanceOf((Throwable)t, Error.class);
            Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
        }
    }

    @Description(value="Returns the hexadecimal representation of the UTF-16BE encoding of the argument")
    @ScalarFunction(value="char2hexint")
    @SqlType(value="varchar")
    public static Slice char2HexInt(@SqlType(value="varchar") Slice string) {
        Slice utf16 = Slices.wrappedBuffer((ByteBuffer)StandardCharsets.UTF_16BE.encode(string.toStringUtf8()));
        String encoded = BaseEncoding.base16().encode(utf16.getBytes());
        return Slices.utf8Slice((String)encoded);
    }
}

