/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testng.services;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.testng.IClassListener;
import org.testng.IExecutionListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestClass;
import org.testng.ITestResult;

public class LogTestDurationListener
implements IExecutionListener,
IClassListener,
IInvokedMethodListener {
    private static final Logger LOG = Logger.get(LogTestDurationListener.class);
    private static final Duration SINGLE_TEST_LOGGING_THRESHOLD = Duration.valueOf((String)"30s");
    private static final Duration CLASS_LOGGING_THRESHOLD = Duration.valueOf((String)"1m");
    private static final Duration GLOBAL_IDLE_LOGGING_THRESHOLD = Duration.valueOf((String)"8m");
    private final ScheduledExecutorService scheduledExecutorService;
    private final Map<String, Long> started = new ConcurrentHashMap<String, Long>();
    private final AtomicLong lastChange = new AtomicLong(System.nanoTime());
    private final AtomicBoolean hangLogged = new AtomicBoolean();
    private final AtomicBoolean finished = new AtomicBoolean();
    @GuardedBy(value="this")
    private ScheduledFuture<?> monitorHangTask;

    public LogTestDurationListener() {
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"TestHangMonitor"));
    }

    public synchronized void onExecutionStart() {
        this.resetHangMonitor();
        this.finished.set(false);
        if (this.monitorHangTask == null) {
            this.monitorHangTask = this.scheduledExecutorService.scheduleWithFixedDelay(this::checkForTestHang, 5L, 5L, TimeUnit.SECONDS);
        }
    }

    public synchronized void onExecutionFinish() {
        this.resetHangMonitor();
        this.finished.set(true);
    }

    private void checkForTestHang() {
        if (this.hangLogged.get()) {
            return;
        }
        Duration duration = Duration.nanosSince((long)this.lastChange.get());
        if (duration.compareTo(GLOBAL_IDLE_LOGGING_THRESHOLD) < 0) {
            return;
        }
        if (!this.hangLogged.compareAndSet(false, true)) {
            return;
        }
        ImmutableMap runningTests = ImmutableMap.copyOf(this.started);
        if (!runningTests.isEmpty()) {
            String testDetails = runningTests.entrySet().stream().map(entry -> String.format("%s running for %s", entry.getKey(), Duration.nanosSince((long)((Long)entry.getValue())))).collect(Collectors.joining("\n\t", "\n\t", ""));
            LogTestDurationListener.dumpAllThreads(String.format("No test started or completed in %s. Running tests:%s.", GLOBAL_IDLE_LOGGING_THRESHOLD, testDetails));
        } else if (this.finished.get()) {
            LogTestDurationListener.dumpAllThreads(String.format("Tests finished, but JVM did not shutdown in %s.", GLOBAL_IDLE_LOGGING_THRESHOLD));
        } else {
            LogTestDurationListener.dumpAllThreads(String.format("No test started in %s", GLOBAL_IDLE_LOGGING_THRESHOLD));
        }
    }

    private static void dumpAllThreads(String message) {
        LOG.warn("%s\n\nFull Thread Dump:\n%s", new Object[]{message, Arrays.stream(ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)).map(ThreadInfo::toString).collect(Collectors.joining("\n"))});
    }

    private void resetHangMonitor() {
        this.lastChange.set(System.nanoTime());
        this.hangLogged.set(false);
    }

    public void onBeforeClass(ITestClass testClass) {
        this.beginExecution(LogTestDurationListener.getName(testClass));
    }

    public void onAfterClass(ITestClass testClass) {
        String name = LogTestDurationListener.getName(testClass);
        Duration duration = this.endExecution(name);
        if (duration.compareTo(CLASS_LOGGING_THRESHOLD) > 0) {
            LOG.warn("Tests from %s took %s", new Object[]{name, duration});
        }
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        this.beginExecution(LogTestDurationListener.getName(method));
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        String name = LogTestDurationListener.getName(method);
        Duration duration = this.endExecution(name);
        if (duration.compareTo(SINGLE_TEST_LOGGING_THRESHOLD) > 0) {
            LOG.info("Test %s took %s", new Object[]{name, duration});
        }
    }

    private void beginExecution(String name) {
        this.resetHangMonitor();
        Long existingEntry = this.started.putIfAbsent(name, System.nanoTime());
        Preconditions.checkState((existingEntry == null ? 1 : 0) != 0, (String)"There already is a start record for test: %s", (Object)name);
    }

    private Duration endExecution(String name) {
        this.resetHangMonitor();
        Long startTime = this.started.remove(name);
        Preconditions.checkState((startTime != null ? 1 : 0) != 0, (String)"There is no start record for test: %s", (Object)name);
        return Duration.nanosSince((long)startTime);
    }

    private static String getName(ITestClass testClass) {
        return testClass.getName();
    }

    private static String getName(IInvokedMethod method) {
        return String.format("%s::%s", method.getTestMethod().getTestClass().getName(), method.getTestMethod().getMethodName());
    }
}

