/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testng.services;

import com.facebook.presto.testng.services.Listeners;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.lang.reflect.Method;
import org.testng.IClassListener;
import org.testng.ITestClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class ReportMultiThreadedBeforeOrAfterMethod
implements IClassListener {
    public void onBeforeClass(ITestClass testClass) {
        try {
            if (!this.isParallel(testClass.getXmlTest())) {
                return;
            }
            ReportMultiThreadedBeforeOrAfterMethod.reportMultiThreadedBeforeOrAfterMethod(testClass.getRealClass());
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(ReportMultiThreadedBeforeOrAfterMethod.class, "Failed to process %s: \n%s", testClass, Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private boolean isParallel(XmlTest xmlTest) {
        if (xmlTest.getThreadCount() == 1) {
            return false;
        }
        XmlSuite.ParallelMode parallel = xmlTest.getParallel();
        return parallel.isParallel();
    }

    @VisibleForTesting
    static void reportMultiThreadedBeforeOrAfterMethod(Class<?> testClass) {
        Method[] methods;
        Test testAnnotation = testClass.getAnnotation(Test.class);
        if (testAnnotation != null && testAnnotation.singleThreaded()) {
            return;
        }
        for (Method method : methods = testClass.getMethods()) {
            if (method.getAnnotation(BeforeMethod.class) == null && method.getAnnotation(AfterMethod.class) == null) continue;
            throw new RuntimeException(String.format("Test class %s should be annotated as @Test(singleThreaded=true), if it contains mutable state as indicated by %s", testClass.getName(), method));
        }
    }

    public void onAfterClass(ITestClass iTestClass) {
    }
}

