/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.statistics;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class StatsContext {
    private final Map<String, Symbol> columnSymbols;
    private final Map<Symbol, Type> symbolTypes;

    public StatsContext(Map<String, Symbol> columnSymbols, Map<Symbol, Type> symbolTypes) {
        this.columnSymbols = ImmutableMap.copyOf(columnSymbols);
        this.symbolTypes = ImmutableMap.copyOf(symbolTypes);
    }

    public Symbol getSymbolForColumn(String columnName) {
        Preconditions.checkArgument((boolean)this.columnSymbols.containsKey(columnName), (Object)("no symbol found for column '" + columnName + "'"));
        return this.columnSymbols.get(columnName);
    }

    public Type getTypeForSymbol(Symbol symbol) {
        Preconditions.checkArgument((boolean)this.symbolTypes.containsKey(symbol), (Object)("no type found found for symbol '" + symbol + "'"));
        return this.symbolTypes.get(symbol);
    }
}

