/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.google.common.base.Preconditions;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestEngineOnlyQueries
extends AbstractTestQueryFramework {
    @Test
    public void testDateLiterals() {
        Session chicago = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"America/Chicago")).build();
        Session kathmandu = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")).build();
        Assert.assertEquals((Object)this.computeScalar("SELECT DATE '2013-03-22'"), (Object)LocalDate.of(2013, 3, 22));
        this.assertQuery("SELECT DATE '2013-03-22'");
        this.assertQuery(chicago, "SELECT DATE '2013-03-22'");
        this.assertQuery(kathmandu, "SELECT DATE '2013-03-22'");
    }

    @Test
    public void testTimeLiterals() {
        Assert.assertEquals((Object)this.computeScalar("SELECT TIME '3:04:05'"), (Object)LocalTime.of(3, 4, 5, 0));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIME '3:04:05.123'"), (Object)LocalTime.of(3, 4, 5, 123000000));
        this.assertQuery("SELECT TIME '3:04:05'");
        this.assertQuery("SELECT TIME '0:04:05'");
        Assert.assertEquals((Object)this.computeScalar("SELECT TIME '01:02:03.400 Z'"), (Object)OffsetTime.of(1, 2, 3, 400000000, ZoneOffset.UTC));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIME '01:02:03.400 UTC'"), (Object)OffsetTime.of(1, 2, 3, 400000000, ZoneOffset.UTC));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIME '3:04:05 +06:00'"), (Object)OffsetTime.of(3, 4, 5, 0, ZoneOffset.ofHoursMinutes(6, 0)));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIME '3:04:05 +0507'"), (Object)OffsetTime.of(3, 4, 5, 0, ZoneOffset.ofHoursMinutes(5, 7)));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIME '3:04:05 +03'"), (Object)OffsetTime.of(3, 4, 5, 0, ZoneOffset.ofHoursMinutes(3, 0)));
    }

    @Test
    public void testTimestampLiterals() {
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '1960-01-22 3:04:05'"), (Object)LocalDateTime.of(1960, 1, 22, 3, 4, 5));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '1960-01-22 3:04:05.123'"), (Object)LocalDateTime.of(1960, 1, 22, 3, 4, 5, 123000000));
        this.assertQuery("SELECT TIMESTAMP '1960-01-22 3:04:05'");
        this.assertQuery("SELECT TIMESTAMP '1960-01-22 3:04:05.123'");
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '1960-01-22 3:04:05 +06:00'"), (Object)ZonedDateTime.of(1960, 1, 22, 3, 4, 5, 0, ZoneOffset.ofHoursMinutes(6, 0)));
    }

    @Test
    public void testLocallyUnrepresentableDateLiterals() {
        LocalDate localDateThatDidNotHaveMidnight = LocalDate.of(1970, 1, 1);
        Preconditions.checkState((boolean)ZoneId.systemDefault().getRules().getValidOffsets(localDateThatDidNotHaveMidnight.atStartOfDay()).isEmpty(), (Object)"This test assumes certain JVM time zone");
        String sql = DateTimeFormatter.ofPattern("'SELECT DATE '''uuuu-MM-dd''").format(localDateThatDidNotHaveMidnight);
        Assert.assertEquals((Object)this.computeScalar(sql), (Object)localDateThatDidNotHaveMidnight);
        this.assertQuery(sql);
    }

    @Test
    public void testLocallyUnrepresentableTimeLiterals() {
        LocalTime localTimeThatDidNotOccurOn19700101 = LocalTime.of(0, 10);
        Preconditions.checkState((boolean)ZoneId.systemDefault().getRules().getValidOffsets(localTimeThatDidNotOccurOn19700101.atDate(LocalDate.ofEpochDay(0L))).isEmpty(), (Object)"This test assumes certain JVM time zone");
        Preconditions.checkState((!Objects.equals(Time.valueOf(localTimeThatDidNotOccurOn19700101).toLocalTime(), localTimeThatDidNotOccurOn19700101) ? 1 : 0) != 0, (Object)"This test assumes certain JVM time zone");
        String sql = DateTimeFormatter.ofPattern("'SELECT TIME '''HH:mm:ss''").format(localTimeThatDidNotOccurOn19700101);
        Assert.assertEquals((Object)this.computeScalar(sql), (Object)localTimeThatDidNotOccurOn19700101);
        this.assertQuery(sql);
    }

    @Test
    public void testLocallyUnrepresentableTimestampLiterals() {
        LocalDateTime localTimeThatDidNotExist = LocalDateTime.of(2017, 4, 2, 2, 10);
        Preconditions.checkState((boolean)ZoneId.systemDefault().getRules().getValidOffsets(localTimeThatDidNotExist).isEmpty(), (Object)"This test assumes certain JVM time zone");
        String sql = DateTimeFormatter.ofPattern("'SELECT TIMESTAMP '''uuuu-MM-dd HH:mm:ss''").format(localTimeThatDidNotExist);
        Assert.assertEquals((Object)this.computeScalar(sql), (Object)localTimeThatDidNotExist);
        this.assertQuery(sql);
    }
}

