package com.facebook.presto.thrift.api.valuesets;

import com.facebook.drift.annotations.ThriftDocumentation;
import com.facebook.drift.annotations.ThriftOrder;

@ThriftDocumentation({
    "A set containing values that are uniquely identifiable.",
    "Assumes an infinite number of possible values. The values may be collectively included (aka whitelist)",
    "or collectively excluded (aka !whitelist).",
    "This structure is used with comparable, but not orderable types like \"json\", \"map\"."
})
class PrestoThriftEquatableValueSet$DriftMeta {
  @ThriftDocumentation
  @ThriftOrder(10000)
  void isWhiteList() {
  }

  @ThriftDocumentation
  @ThriftOrder(10001)
  void getValues() {
  }
}
