package com.facebook.presto.thrift.api.datatypes;

import com.facebook.drift.annotations.ThriftDocumentation;
import com.facebook.drift.annotations.ThriftOrder;

@ThriftDocumentation({
    "Elements of {@code nulls} array determine if a value for a corresponding row is null.",
    "Each elements of {@code sizes} array contains the length in bytes for the corresponding element.",
    "If row is null then the corresponding element in {@code sizes} is ignored.",
    "{@code bytes} array contains UTF-8 encoded byte values.",
    "Values for all rows are written to {@code bytes} array one after another.",
    "The total number of bytes must be equal to the sum of all sizes."
})
class PrestoThriftVarchar$DriftMeta {
  @ThriftDocumentation
  @ThriftOrder(10000)
  void getNulls() {
  }

  @ThriftDocumentation
  @ThriftOrder(10001)
  void getSizes() {
  }

  @ThriftDocumentation
  @ThriftOrder(10002)
  void getBytes() {
  }
}
