package com.facebook.presto.thrift.api.connector;

import com.facebook.drift.annotations.ThriftDocumentation;
import com.facebook.drift.annotations.ThriftOrder;

@ThriftDocumentation({
    "Presto Thrift service definition.",
    "This thrift service needs to be implemented in order to be used with Thrift Connector."
})
class PrestoThriftService$DriftMeta {
  @ThriftDocumentation("Returns available schema names.")
  @ThriftOrder(10000)
  void listSchemaNames() {
  }

  @ThriftDocumentation({
      "Returns tables for the given schema name.",
      "",
      "@param schemaNameOrNull a structure containing schema name or {@literal null}",
      "@return a list of table names with corresponding schemas. If schema name is null then returns",
      "a list of tables for all schemas. Returns an empty list if a schema does not exist"
  })
  @ThriftOrder(10001)
  void listTables() {
  }

  @ThriftDocumentation({
      "Returns metadata for a given table.",
      "",
      "@param schemaTableName schema and table name",
      "@return metadata for a given table, or a {@literal null} value inside if it does not exist"
  })
  @ThriftOrder(10002)
  void getTableMetadata() {
  }

  @ThriftDocumentation({
      "Returns a batch of splits.",
      "",
      "@param schemaTableName schema and table name",
      "@param desiredColumns a superset of columns to return; empty set means \"no columns\", {@literal null} set means \"all columns\"",
      "@param outputConstraint constraint on the returned data",
      "@param maxSplitCount maximum number of splits to return",
      "@param nextToken token from a previous split batch or {@literal null} if it is the first call",
      "@return a batch of splits"
  })
  @ThriftOrder(10003)
  void getSplits() {
  }

  @ThriftDocumentation({
      "Returns a batch of index splits for the given batch of keys.",
      "This method is called if index join strategy is chosen for a query.",
      "",
      "@param schemaTableName schema and table name",
      "@param indexColumnNames specifies columns and their order for keys",
      "@param outputColumnNames a list of column names to return",
      "@param keys keys for which records need to be returned; includes only unique and non-null values",
      "@param outputConstraint constraint on the returned data",
      "@param maxSplitCount maximum number of splits to return",
      "@param nextToken token from a previous split batch or {@literal null} if it is the first call",
      "@return a batch of splits"
  })
  @ThriftOrder(10004)
  void getIndexSplits() {
  }

  @ThriftDocumentation({
      "Returns a batch of rows for the given split.",
      "",
      "@param splitId split id as returned in split batch",
      "@param columns a list of column names to return",
      "@param maxBytes maximum size of returned data in bytes",
      "@param nextToken token from a previous batch or {@literal null} if it is the first call",
      "@return a batch of table data"
  })
  @ThriftOrder(10005)
  void getRows() {
  }
}
