package com.facebook.presto.thrift.api.datatypes;

import com.facebook.drift.annotations.ThriftDocumentation;
import com.facebook.drift.annotations.ThriftOrder;

@ThriftDocumentation({
    "Elements of {@code nulls} array determine if a value for a corresponding row is null.",
    "Each elements of {@code sizes} array contains the number of elements in the corresponding values array.",
    "If row is null then the corresponding element in {@code sizes} is ignored.",
    "{@code values} is a bigint block containing array elements one after another for all rows.",
    "The total number of elements in bigint block must be equal to the sum of all sizes."
})
class PrestoThriftBigintArray$DriftMeta {
  @ThriftDocumentation
  @ThriftOrder(10000)
  void getNulls() {
  }

  @ThriftDocumentation
  @ThriftOrder(10001)
  void getSizes() {
  }

  @ThriftDocumentation
  @ThriftOrder(10002)
  void getValues() {
  }
}
