package com.facebook.presto.thrift.api.datatypes;

import com.facebook.drift.annotations.ThriftDocumentation;
import com.facebook.drift.annotations.ThriftOrder;

@ThriftDocumentation({
    "Elements of {@code nulls} array determine if a value for a corresponding row is null.",
    "Elements of {@code timestamps} array are values for each row represented as the number",
    "of milliseconds passed since 1970-01-01T00:00:00 UTC.",
    "If row is null then value is ignored."
})
class PrestoThriftTimestamp$DriftMeta {
  @ThriftDocumentation
  @ThriftOrder(10000)
  void getNulls() {
  }

  @ThriftDocumentation
  @ThriftOrder(10001)
  void getTimestamps() {
  }
}
