package com.facebook.presto.thrift.api.connector;

import com.facebook.drift.annotations.ThriftDocumentation;
import com.facebook.drift.annotations.ThriftOrder;

@ThriftDocumentation
class PrestoThriftSplit$DriftMeta {
  @ThriftDocumentation({
      "Encodes all the information needed to identify a batch of rows to return to Presto.",
      "For a basic scan, includes schema name, table name, and output constraint.",
      "For an index scan, includes schema name, table name, set of keys to lookup and output constraint."
  })
  @ThriftOrder(10000)
  void getSplitId() {
  }

  @ThriftDocumentation({
      "Identifies the set of hosts on which the rows are available. If empty, then the rows",
      "are expected to be available on any host. The hosts in this list may be independent",
      "from the hosts used to serve metadata requests."
  })
  @ThriftOrder(10001)
  void getHosts() {
  }
}
