/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift.api.datatypes;

import com.facebook.presto.connector.thrift.api.PrestoThriftBlock;
import com.facebook.presto.connector.thrift.api.datatypes.PrestoThriftColumnData;
import com.facebook.presto.connector.thrift.api.datatypes.PrestoThriftTypeUtils;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.IntArrayBlock;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct
public final class PrestoThriftDate
implements PrestoThriftColumnData {
    private final boolean[] nulls;
    private final int[] dates;

    @ThriftConstructor
    public PrestoThriftDate(@ThriftField(name="nulls") @Nullable boolean[] nulls, @ThriftField(name="dates") @Nullable int[] dates) {
        Preconditions.checkArgument((boolean)PrestoThriftDate.sameSizeIfPresent(nulls, dates), (Object)"nulls and values must be of the same size");
        this.nulls = nulls;
        this.dates = dates;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public int[] getDates() {
        return this.dates;
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((boolean)DateType.DATE.equals((Object)desiredType), (String)"type doesn't match: %s", (Object)desiredType);
        int numberOfRecords = this.numberOfRecords();
        return new IntArrayBlock(numberOfRecords, this.nulls == null ? new boolean[numberOfRecords] : this.nulls, this.dates == null ? new int[numberOfRecords] : this.dates);
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.dates != null) {
            return this.dates.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftDate other = (PrestoThriftDate)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.dates, other.dates);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.dates));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static PrestoThriftBlock fromBlock(Block block) {
        return PrestoThriftTypeUtils.fromIntBasedBlock(block, (Type)DateType.DATE, (nulls, ints) -> PrestoThriftBlock.dateData(new PrestoThriftDate((boolean[])nulls, (int[])ints)));
    }

    public static PrestoThriftBlock fromRecordSetColumn(RecordSet recordSet, int columnIndex, int totalRecords) {
        return PrestoThriftTypeUtils.fromIntBasedColumn(recordSet, columnIndex, totalRecords, (nulls, ints) -> PrestoThriftBlock.dateData(new PrestoThriftDate((boolean[])nulls, (int[])ints)));
    }

    private static boolean sameSizeIfPresent(boolean[] nulls, int[] dates) {
        return nulls == null || dates == null || nulls.length == dates.length;
    }
}

