/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift.api.valuesets;

import com.facebook.presto.connector.thrift.api.PrestoThriftBlock;
import com.facebook.presto.spi.predicate.EquatableValueSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@ThriftStruct
public final class PrestoThriftEquatableValueSet {
    private final boolean whiteList;
    private final List<PrestoThriftBlock> values;

    @ThriftConstructor
    public PrestoThriftEquatableValueSet(boolean whiteList, List<PrestoThriftBlock> values) {
        this.whiteList = whiteList;
        this.values = Objects.requireNonNull(values, "values are null");
    }

    @ThriftField(value=1)
    public boolean isWhiteList() {
        return this.whiteList;
    }

    @ThriftField(value=2)
    public List<PrestoThriftBlock> getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftEquatableValueSet other = (PrestoThriftEquatableValueSet)obj;
        return this.whiteList == other.whiteList && Objects.equals(this.values, other.values);
    }

    public int hashCode() {
        return Objects.hash(this.whiteList, this.values);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("whiteList", this.whiteList).add("values", this.values).toString();
    }

    public static PrestoThriftEquatableValueSet fromEquatableValueSet(EquatableValueSet valueSet) {
        Type type = valueSet.getType();
        Set values = valueSet.getEntries();
        ArrayList<PrestoThriftBlock> thriftValues = new ArrayList<PrestoThriftBlock>(values.size());
        for (EquatableValueSet.ValueEntry value : values) {
            Preconditions.checkState((boolean)type.equals(value.getType()), (String)"ValueEntrySet has elements of different types: %s vs %s", (Object)type, (Object)value.getType());
            thriftValues.add(PrestoThriftBlock.fromBlock(value.getBlock(), type));
        }
        return new PrestoThriftEquatableValueSet(valueSet.isWhiteList(), thriftValues);
    }
}

