/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.client.address;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.drift.client.address.AddressSelector;
import io.airlift.drift.client.address.SimpleAddressSelectorConfig;
import io.airlift.drift.transport.client.Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class SimpleAddressSelector
implements AddressSelector<Address> {
    private final Set<HostAndPort> addresses;

    public SimpleAddressSelector(SimpleAddressSelectorConfig config) {
        this(config.getAddresses());
    }

    public SimpleAddressSelector(Iterable<HostAndPort> addresses) {
        for (HostAndPort address : addresses) {
            Preconditions.checkArgument((address.getPortOrDefault(0) > 0 ? 1 : 0) != 0, (Object)"address port must be set");
        }
        this.addresses = ImmutableSet.copyOf(addresses);
    }

    @VisibleForTesting
    Set<HostAndPort> getAddresses() {
        return this.addresses;
    }

    @Override
    public Optional<Address> selectAddress(Optional<String> addressSelectionContext) {
        Preconditions.checkArgument((!addressSelectionContext.isPresent() ? 1 : 0) != 0, (Object)"addressSelectionContext should not be set");
        ArrayList<HostAndPort> result = new ArrayList<HostAndPort>();
        for (HostAndPort address : this.addresses) {
            try {
                for (InetAddress ip : InetAddress.getAllByName(address.getHost())) {
                    result.add(HostAndPort.fromParts((String)ip.getHostAddress(), (int)address.getPort()));
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
        }
        if (result.isEmpty()) {
            return Optional.empty();
        }
        HostAndPort hostAndPort = (HostAndPort)result.get(ThreadLocalRandom.current().nextInt(result.size()));
        return Optional.of(() -> hostAndPort);
    }

    @Override
    public void markdown(Address address) {
    }
}

