/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.presto.connector.thrift.ThriftConnectorConfig;
import com.facebook.presto.connector.thrift.ThriftConnectorSplit;
import com.facebook.presto.connector.thrift.ThriftConnectorStats;
import com.facebook.presto.connector.thrift.ThriftHeaderProvider;
import com.facebook.presto.connector.thrift.ThriftPageSource;
import com.facebook.presto.connector.thrift.api.PrestoThriftService;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import io.airlift.drift.client.DriftClient;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ThriftPageSourceProvider
implements ConnectorPageSourceProvider {
    private final DriftClient<PrestoThriftService> client;
    private final ThriftHeaderProvider thriftHeaderProvider;
    private final long maxBytesPerResponse;
    private final ThriftConnectorStats stats;

    @Inject
    public ThriftPageSourceProvider(DriftClient<PrestoThriftService> client, ThriftHeaderProvider thriftHeaderProvider, ThriftConnectorStats stats, ThriftConnectorConfig config) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaderProvider = Objects.requireNonNull(thriftHeaderProvider, "thriftHeaderFactor is null");
        this.maxBytesPerResponse = Objects.requireNonNull(config, "config is null").getMaxResponseSize().toBytes();
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns) {
        return new ThriftPageSource(this.client, this.thriftHeaderProvider.getHeaders(session), (ThriftConnectorSplit)split, columns, this.stats, this.maxBytesPerResponse);
    }
}

