/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ThriftTableLayoutHandle
implements ConnectorTableLayoutHandle {
    private final String schemaName;
    private final String tableName;
    private final Optional<Set<ColumnHandle>> columns;
    private final TupleDomain<ColumnHandle> constraint;

    @JsonCreator
    public ThriftTableLayoutHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columns") Optional<Set<ColumnHandle>> columns, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.columns = Objects.requireNonNull(columns, "columns is null").map(ImmutableSet::copyOf);
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public Optional<Set<ColumnHandle>> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftTableLayoutHandle other = (ThriftTableLayoutHandle)o;
        return this.schemaName.equals(other.schemaName) && this.tableName.equals(other.tableName) && this.columns.equals(other.columns) && this.constraint.equals(other.constraint);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.columns, this.constraint);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("columns", this.columns).add("constraint", this.constraint).toString();
    }
}

