/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift.util;

import com.facebook.presto.connector.thrift.ThriftErrorCode;
import com.facebook.presto.connector.thrift.api.PrestoThriftServiceException;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.drift.TApplicationException;
import io.airlift.drift.TException;
import io.airlift.drift.protocol.TTransportException;

public final class ThriftExceptions {
    private ThriftExceptions() {
    }

    public static PrestoException toPrestoException(Exception e) {
        if (e instanceof TTransportException && "No hosts available".equals(e.getMessage())) {
            throw new PrestoException((ErrorCodeSupplier)ThriftErrorCode.THRIFT_SERVICE_NO_AVAILABLE_HOSTS, (Throwable)e);
        }
        if (e instanceof TApplicationException || e instanceof PrestoThriftServiceException) {
            return new PrestoException((ErrorCodeSupplier)ThriftErrorCode.THRIFT_SERVICE_GENERIC_REMOTE_ERROR, "Exception raised by remote Thrift server", (Throwable)e);
        }
        if (e instanceof TException) {
            return new PrestoException((ErrorCodeSupplier)ThriftErrorCode.THRIFT_SERVICE_CONNECTION_ERROR, "Error communicating with remote Thrift server", (Throwable)e);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
    }

    public static <T> ListenableFuture<T> catchingThriftException(ListenableFuture<T> future) {
        return Futures.catchingAsync(future, Exception.class, e -> Futures.immediateFailedFuture((Throwable)ThriftExceptions.toPrestoException(e)));
    }
}

