/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal.builtin;

import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.internal.ProtocolReader;
import io.airlift.drift.codec.internal.ProtocolWriter;
import io.airlift.drift.codec.metadata.ThriftType;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ListThriftCodec<T>
implements ThriftCodec<List<T>> {
    private final ThriftCodec<T> elementCodec;
    private final ThriftType type;

    public ListThriftCodec(ThriftType type, ThriftCodec<T> elementCodec) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.elementCodec = Objects.requireNonNull(elementCodec, "elementCodec is null");
    }

    @Override
    public ThriftType getType() {
        return this.type;
    }

    @Override
    public List<T> read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return new ProtocolReader(protocol).readList(this.elementCodec);
    }

    @Override
    public void write(List<T> value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        new ProtocolWriter(protocol).writeList(this.elementCodec, value);
    }
}

