/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.drift.TException;
import io.airlift.drift.annotations.ThriftException;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftHeader;
import io.airlift.drift.annotations.ThriftIdlAnnotation;
import io.airlift.drift.annotations.ThriftMethod;
import io.airlift.drift.annotations.ThriftStruct;
import io.airlift.drift.codec.metadata.DefaultThriftTypeReference;
import io.airlift.drift.codec.metadata.FieldKind;
import io.airlift.drift.codec.metadata.ReflectionHelper;
import io.airlift.drift.codec.metadata.ThriftCatalog;
import io.airlift.drift.codec.metadata.ThriftFieldMetadata;
import io.airlift.drift.codec.metadata.ThriftHeaderParameter;
import io.airlift.drift.codec.metadata.ThriftInjection;
import io.airlift.drift.codec.metadata.ThriftParameterInjection;
import io.airlift.drift.codec.metadata.ThriftType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftMethodMetadata {
    private final String name;
    private final ThriftType returnType;
    private final List<ThriftFieldMetadata> parameters;
    private final Set<ThriftHeaderParameter> headerParameters;
    private final Method method;
    private final ImmutableMap<Short, ThriftType> exceptions;
    private final boolean oneway;
    private final boolean idempotent;
    private final List<String> documentation;

    public ThriftMethodMetadata(Method method, ThriftCatalog catalog) {
        Objects.requireNonNull(method, "method is null");
        Objects.requireNonNull(catalog, "catalog is null");
        this.method = method;
        ThriftMethod thriftMethod = method.getAnnotation(ThriftMethod.class);
        Preconditions.checkArgument((thriftMethod != null ? 1 : 0) != 0, (Object)"Method is not annotated with @ThriftMethod");
        Preconditions.checkArgument((!Modifier.isStatic(method.getModifiers()) ? 1 : 0) != 0, (String)"Method %s is static", (Object)method.toGenericString());
        this.name = thriftMethod.value().isEmpty() ? method.getName() : thriftMethod.value();
        this.returnType = catalog.getThriftType(method.getGenericReturnType());
        ImmutableList.Builder thriftParameterBuilder = ImmutableList.builder();
        ImmutableSet.Builder headerParameterBuilder = ImmutableSet.builder();
        Type[] parameterTypes = method.getGenericParameterTypes();
        List<String> parameterNames = ReflectionHelper.extractParameterNames(method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        short nextThriftFieldId = 1;
        for (int parameterIndex = 0; parameterIndex < parameterTypes.length; ++parameterIndex) {
            ThriftField thriftField = Stream.of(parameterAnnotations[parameterIndex]).filter(ThriftField.class::isInstance).map(ThriftField.class::cast).findAny().orElse(null);
            ThriftHeader thriftHeader = Stream.of(parameterAnnotations[parameterIndex]).filter(ThriftHeader.class::isInstance).map(ThriftHeader.class::cast).findAny().orElse(null);
            if (thriftHeader != null) {
                Preconditions.checkArgument((thriftField == null ? 1 : 0) != 0, (String)"ThriftMethod [%s] parameter %s must not be annotated with both @ThriftField and @ThriftHeader", (Object)ThriftMethodMetadata.methodName(method), (int)parameterIndex);
                Preconditions.checkArgument((parameterTypes[parameterIndex] == String.class ? 1 : 0) != 0, (String)"ThriftMethod [%s] parameter %s annotated with @ThriftHeader must be a String", (Object)ThriftMethodMetadata.methodName(method), (int)parameterIndex);
                String headerName = thriftHeader.value();
                Preconditions.checkArgument((!headerName.isEmpty() ? 1 : 0) != 0, (String)"ThriftMethod [%s] parameter %s @ThriftHeader.name must not be empty", (Object)ThriftMethodMetadata.methodName(method), (int)parameterIndex);
                headerParameterBuilder.add((Object)new ThriftHeaderParameter(parameterIndex, headerName));
                continue;
            }
            short thriftFieldId = Short.MIN_VALUE;
            boolean isLegacyId = false;
            String parameterName = null;
            ImmutableMap parameterIdlAnnotations = null;
            ThriftField.Requiredness parameterRequiredness = ThriftField.Requiredness.UNSPECIFIED;
            if (thriftField != null) {
                thriftFieldId = thriftField.value();
                isLegacyId = thriftField.isLegacyId();
                parameterRequiredness = thriftField.requiredness();
                ImmutableMap.Builder idlAnnotationsBuilder = ImmutableMap.builder();
                for (ThriftIdlAnnotation idlAnnotation : thriftField.idlAnnotations()) {
                    idlAnnotationsBuilder.put((Object)idlAnnotation.key(), (Object)idlAnnotation.value());
                }
                parameterIdlAnnotations = idlAnnotationsBuilder.build();
                if (!thriftField.name().isEmpty()) {
                    parameterName = thriftField.name();
                }
            }
            if (thriftFieldId == Short.MIN_VALUE) {
                thriftFieldId = nextThriftFieldId;
            }
            nextThriftFieldId = (short)(nextThriftFieldId + 1);
            if (parameterName == null) {
                parameterName = parameterNames.get(parameterIndex);
            }
            Type parameterType = parameterTypes[parameterIndex];
            ThriftType thriftType = catalog.getThriftType(parameterType);
            ThriftParameterInjection parameterInjection = new ThriftParameterInjection(thriftFieldId, parameterName, parameterIndex, parameterType);
            if (parameterRequiredness == ThriftField.Requiredness.UNSPECIFIED) {
                parameterRequiredness = ThriftField.Requiredness.NONE;
            }
            ThriftFieldMetadata fieldMetadata = new ThriftFieldMetadata(thriftFieldId, isLegacyId, false, parameterRequiredness, (Map<String, String>)parameterIdlAnnotations, new DefaultThriftTypeReference(thriftType), parameterName, FieldKind.THRIFT_FIELD, (List<ThriftInjection>)ImmutableList.of((Object)parameterInjection), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            thriftParameterBuilder.add((Object)fieldMetadata);
        }
        this.parameters = thriftParameterBuilder.build();
        this.headerParameters = headerParameterBuilder.build();
        this.exceptions = this.buildExceptionMap(catalog, thriftMethod);
        this.oneway = thriftMethod.oneway();
        this.idempotent = thriftMethod.idempotent();
        this.documentation = ThriftCatalog.getThriftDocumentation(method);
    }

    public String getName() {
        return this.name;
    }

    public ThriftType getReturnType() {
        return this.returnType;
    }

    public List<ThriftFieldMetadata> getParameters() {
        return this.parameters;
    }

    public Set<ThriftHeaderParameter> getHeaderParameters() {
        return this.headerParameters;
    }

    public Map<Short, ThriftType> getExceptions() {
        return this.exceptions;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean getOneway() {
        return this.oneway;
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public List<String> getDocumentation() {
        return this.documentation;
    }

    private ImmutableMap<Short, ThriftType> buildExceptionMap(ThriftCatalog catalog, ThriftMethod thriftMethod) {
        ImmutableMap.Builder exceptions = ImmutableMap.builder();
        HashSet<Class> exceptionTypes = new HashSet<Class>();
        int customExceptionCount = 0;
        if (thriftMethod.exception().length > 0) {
            for (ThriftException thriftException : thriftMethod.exception()) {
                exceptions.put((Object)thriftException.id(), (Object)catalog.getThriftType(thriftException.type()));
                Preconditions.checkArgument((boolean)exceptionTypes.add(thriftException.type()), (String)"ThriftMethod [%s] exception list contains more than one value for %s", (Object)ThriftMethodMetadata.methodName(this.method), (Object)thriftException.type());
            }
        }
        for (Class<TException> clazz : this.method.getExceptionTypes()) {
            if (clazz.isAssignableFrom(TException.class)) continue;
            Preconditions.checkArgument((boolean)clazz.isAnnotationPresent(ThriftStruct.class), (String)"ThriftMethod [%s] exception [%s] is not annotated with @ThriftStruct", (Object)ThriftMethodMetadata.methodName(this.method), (Object)clazz.getSimpleName());
            ++customExceptionCount;
            if (exceptionTypes.contains(clazz)) continue;
            Preconditions.checkArgument((customExceptionCount <= 1 ? 1 : 0) != 0, (String)"ThriftMethod [%s] annotation must declare exception mapping when more than one custom exception is thrown", (Object)ThriftMethodMetadata.methodName(this.method));
            exceptions.put((Object)1, (Object)catalog.getThriftType(clazz));
        }
        return exceptions.build();
    }

    public boolean isAsync() {
        Type returnType = this.method.getGenericReturnType();
        Class rawType = TypeToken.of((Type)returnType).getRawType();
        return ListenableFuture.class.isAssignableFrom(rawType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftMethodMetadata that = (ThriftMethodMetadata)o;
        return this.oneway == that.oneway && Objects.equals(this.name, that.name) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.headerParameters, that.headerParameters) && Objects.equals(this.method, that.method) && Objects.equals(this.exceptions, that.exceptions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.returnType, this.parameters, this.headerParameters, this.method, this.exceptions, this.oneway);
    }

    private static String methodName(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName();
    }
}

