/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import io.airlift.drift.annotations.ThriftMethod;
import io.airlift.drift.annotations.ThriftService;
import io.airlift.drift.codec.metadata.ReflectionHelper;
import io.airlift.drift.codec.metadata.ThriftCatalog;
import io.airlift.drift.codec.metadata.ThriftMethodMetadata;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftServiceMetadata {
    private final String name;
    private final String idlName;
    private final Map<String, ThriftMethodMetadata> methods;
    private final List<String> documentation;

    public ThriftServiceMetadata(Class<?> serviceClass, ThriftCatalog catalog) {
        Objects.requireNonNull(serviceClass, "serviceClass is null");
        ThriftService thriftService = ThriftServiceMetadata.getThriftServiceAnnotation(serviceClass);
        this.name = thriftService.value().isEmpty() ? serviceClass.getSimpleName() : thriftService.value();
        this.idlName = thriftService.idlName().isEmpty() ? this.name : thriftService.idlName();
        TreeMultimap builder = TreeMultimap.create((Comparator)Ordering.natural().nullsLast(), (Comparator)Ordering.natural().onResultOf(ThriftMethodMetadata::getName));
        for (Method method : ReflectionHelper.findAnnotatedMethods(serviceClass, ThriftMethod.class)) {
            if (!method.isAnnotationPresent(ThriftMethod.class)) continue;
            builder.put((Object)ThriftCatalog.getMethodOrder(method), (Object)new ThriftMethodMetadata(method, catalog));
        }
        this.methods = (Map)builder.values().stream().collect(ImmutableMap.toImmutableMap(ThriftMethodMetadata::getName, Function.identity()));
        this.documentation = ThriftCatalog.getThriftDocumentation(serviceClass);
    }

    public String getName() {
        return this.name;
    }

    public String getIdlName() {
        return this.idlName;
    }

    public Map<String, ThriftMethodMetadata> getMethods() {
        return this.methods;
    }

    public List<String> getDocumentation() {
        return this.documentation;
    }

    public static ThriftService getThriftServiceAnnotation(Class<?> serviceClass) {
        Set<ThriftService> serviceAnnotations = ReflectionHelper.getEffectiveClassAnnotations(serviceClass, ThriftService.class);
        Preconditions.checkArgument((!serviceAnnotations.isEmpty() ? 1 : 0) != 0, (String)"Service class %s is not annotated with @ThriftService", (Object)serviceClass.getName());
        Preconditions.checkArgument((serviceAnnotations.size() == 1 ? 1 : 0) != 0, (String)"Service class %s has multiple conflicting @ThriftService annotations: %s", (Object)serviceClass.getName(), serviceAnnotations);
        return (ThriftService)Iterables.getOnlyElement(serviceAnnotations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftServiceMetadata that = (ThriftServiceMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.methods, that.methods);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.methods);
    }
}

