/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.thrift.api.connector.PrestoThriftId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ThriftConnectorSplit
implements ConnectorSplit {
    private final PrestoThriftId splitId;
    private final List<HostAddress> addresses;

    @JsonCreator
    public ThriftConnectorSplit(@JsonProperty(value="splitId") PrestoThriftId splitId, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        this.splitId = Objects.requireNonNull(splitId, "splitId is null");
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
    }

    @JsonProperty
    public PrestoThriftId getSplitId() {
        return this.splitId;
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        return this.addresses;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Object getInfo() {
        return "";
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftConnectorSplit other = (ThriftConnectorSplit)obj;
        return Objects.equals(this.splitId, other.splitId) && Objects.equals(this.addresses, other.addresses);
    }

    public int hashCode() {
        return Objects.hash(this.splitId, this.addresses);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("splitId", (Object)this.splitId).add("addresses", this.addresses).toString();
    }
}

