/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.drift.client.DriftMethodInvocation;
import com.facebook.drift.client.RetryPolicy;
import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.client.stats.MethodInvocationStat;
import com.facebook.drift.codec.metadata.ThriftHeaderParameter;
import com.facebook.drift.transport.MethodMetadata;
import com.facebook.drift.transport.client.Address;
import com.facebook.drift.transport.client.MethodInvoker;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

class DriftMethodHandler {
    private final MethodMetadata metadata;
    private final Map<Integer, ThriftHeaderParameter> headerParameters;
    private final MethodInvoker invoker;
    private final boolean async;
    private final AddressSelector<? extends Address> addressSelector;
    private final RetryPolicy retryPolicy;
    private final MethodInvocationStat stat;
    private final BoundedExecutor retryService;

    public DriftMethodHandler(MethodMetadata metadata, Set<ThriftHeaderParameter> headersParameters, MethodInvoker invoker, boolean async, AddressSelector<? extends Address> addressSelector, RetryPolicy retryPolicy, MethodInvocationStat stat, BoundedExecutor retryService) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.headerParameters = (Map)Objects.requireNonNull(headersParameters, "headersParameters is null").stream().collect(ImmutableMap.toImmutableMap(ThriftHeaderParameter::getIndex, Function.identity()));
        this.invoker = Objects.requireNonNull(invoker, "invoker is null");
        this.async = async;
        this.addressSelector = Objects.requireNonNull(addressSelector, "addressSelector is null");
        this.retryPolicy = retryPolicy;
        this.stat = Objects.requireNonNull(stat, "stat is null");
        this.retryService = Objects.requireNonNull(retryService, "retryService is null");
    }

    public boolean isAsync() {
        return this.async;
    }

    public ListenableFuture<Object> invoke(Optional<String> addressSelectionContext, Map<String, String> headers, List<Object> parameters) {
        if (!this.headerParameters.isEmpty()) {
            headers = new LinkedHashMap<String, String>(headers);
            for (Map.Entry<Integer, ThriftHeaderParameter> entry : this.headerParameters.entrySet()) {
                String headerValue = (String)parameters.get(entry.getKey());
                if (headerValue == null) continue;
                headers.put(entry.getValue().getName(), headerValue);
            }
            ImmutableList.Builder newParameters = ImmutableList.builder();
            for (int index = 0; index < parameters.size(); ++index) {
                if (this.headerParameters.containsKey(index)) continue;
                newParameters.add(parameters.get(index));
            }
            parameters = newParameters.build();
        }
        return DriftMethodInvocation.createDriftMethodInvocation(this.invoker, this.metadata, headers, parameters, this.retryPolicy, this.addressSelector, addressSelectionContext, this.stat, Ticker.systemTicker(), this.retryService);
    }
}

