/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.drift.client.DriftClient;
import com.facebook.presto.connector.thrift.ThriftConnectorStats;
import com.facebook.presto.connector.thrift.ThriftIndexHandle;
import com.facebook.presto.connector.thrift.ThriftIndexPageSource;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorIndex;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.thrift.api.connector.PrestoThriftService;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ThriftConnectorIndex
implements ConnectorIndex {
    private final DriftClient<PrestoThriftService> client;
    private final Map<String, String> thriftHeaders;
    private final ThriftIndexHandle indexHandle;
    private final List<ColumnHandle> lookupColumns;
    private final List<ColumnHandle> outputColumns;
    private final long maxBytesPerResponse;
    private final int lookupRequestsConcurrency;
    private final ThriftConnectorStats stats;

    public ThriftConnectorIndex(DriftClient<PrestoThriftService> client, Map<String, String> thriftHeaders, ThriftConnectorStats stats, ThriftIndexHandle indexHandle, List<ColumnHandle> lookupColumns, List<ColumnHandle> outputColumns, long maxBytesPerResponse, int lookupRequestsConcurrency) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaders = Objects.requireNonNull(thriftHeaders, "thriftHeaders is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.indexHandle = Objects.requireNonNull(indexHandle, "indexHandle is null");
        this.lookupColumns = Objects.requireNonNull(lookupColumns, "lookupColumns is null");
        this.outputColumns = Objects.requireNonNull(outputColumns, "outputColumns is null");
        this.maxBytesPerResponse = maxBytesPerResponse;
        this.lookupRequestsConcurrency = lookupRequestsConcurrency;
    }

    public ConnectorPageSource lookup(RecordSet recordSet) {
        return new ThriftIndexPageSource(this.client, this.thriftHeaders, this.stats, this.indexHandle, this.lookupColumns, this.outputColumns, recordSet, this.maxBytesPerResponse, this.lookupRequestsConcurrency);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("indexHandle", (Object)this.indexHandle).add("lookupColumns", this.lookupColumns).add("outputColumns", this.outputColumns).toString();
    }
}

