/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift.api.valuesets;

import com.facebook.presto.connector.thrift.api.valuesets.PrestoThriftAllOrNoneValueSet;
import com.facebook.presto.connector.thrift.api.valuesets.PrestoThriftEquatableValueSet;
import com.facebook.presto.connector.thrift.api.valuesets.PrestoThriftRangeValueSet;
import com.facebook.presto.spi.predicate.AllOrNoneValueSet;
import com.facebook.presto.spi.predicate.EquatableValueSet;
import com.facebook.presto.spi.predicate.SortedRangeSet;
import com.facebook.presto.spi.predicate.ValueSet;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct
public final class PrestoThriftValueSet {
    private final PrestoThriftAllOrNoneValueSet allOrNoneValueSet;
    private final PrestoThriftEquatableValueSet equatableValueSet;
    private final PrestoThriftRangeValueSet rangeValueSet;

    @ThriftConstructor
    public PrestoThriftValueSet(@Nullable PrestoThriftAllOrNoneValueSet allOrNoneValueSet, @Nullable PrestoThriftEquatableValueSet equatableValueSet, @Nullable PrestoThriftRangeValueSet rangeValueSet) {
        Preconditions.checkArgument((boolean)PrestoThriftValueSet.isExactlyOneNonNull(allOrNoneValueSet, equatableValueSet, rangeValueSet), (Object)"exactly one value set must be present");
        this.allOrNoneValueSet = allOrNoneValueSet;
        this.equatableValueSet = equatableValueSet;
        this.rangeValueSet = rangeValueSet;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftAllOrNoneValueSet getAllOrNoneValueSet() {
        return this.allOrNoneValueSet;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftEquatableValueSet getEquatableValueSet() {
        return this.equatableValueSet;
    }

    @Nullable
    @ThriftField(value=3, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftRangeValueSet getRangeValueSet() {
        return this.rangeValueSet;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftValueSet other = (PrestoThriftValueSet)obj;
        return Objects.equals(this.allOrNoneValueSet, other.allOrNoneValueSet) && Objects.equals(this.equatableValueSet, other.equatableValueSet) && Objects.equals(this.rangeValueSet, other.rangeValueSet);
    }

    public int hashCode() {
        return Objects.hash(this.allOrNoneValueSet, this.equatableValueSet, this.rangeValueSet);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("valueSet", PrestoThriftValueSet.firstNonNull(this.allOrNoneValueSet, this.equatableValueSet, this.rangeValueSet)).toString();
    }

    public static PrestoThriftValueSet fromValueSet(ValueSet valueSet) {
        if (valueSet.getClass() == AllOrNoneValueSet.class) {
            return new PrestoThriftValueSet(PrestoThriftAllOrNoneValueSet.fromAllOrNoneValueSet((AllOrNoneValueSet)valueSet), null, null);
        }
        if (valueSet.getClass() == EquatableValueSet.class) {
            return new PrestoThriftValueSet(null, PrestoThriftEquatableValueSet.fromEquatableValueSet((EquatableValueSet)valueSet), null);
        }
        if (valueSet.getClass() == SortedRangeSet.class) {
            return new PrestoThriftValueSet(null, null, PrestoThriftRangeValueSet.fromSortedRangeSet((SortedRangeSet)valueSet));
        }
        throw new IllegalArgumentException("Unknown implementation of a value set: " + valueSet.getClass());
    }

    private static boolean isExactlyOneNonNull(Object a, Object b, Object c) {
        return a != null && b == null && c == null || a == null && b != null && c == null || a == null && b == null && c != null;
    }

    private static Object firstNonNull(Object a, Object b, Object c) {
        if (a != null) {
            return a;
        }
        if (b != null) {
            return b;
        }
        if (c != null) {
            return c;
        }
        throw new IllegalArgumentException("All arguments are null");
    }
}

