/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.discovery.client.DiscoveryAnnouncementClient;
import io.airlift.discovery.client.DiscoveryException;
import io.airlift.discovery.client.DiscoveryLookupClient;
import io.airlift.discovery.client.ForDiscoveryClient;
import io.airlift.discovery.client.ServiceDescriptors;
import io.airlift.discovery.client.ServiceDescriptorsRepresentation;
import io.airlift.http.client.CacheControl;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class HttpDiscoveryLookupClient
implements DiscoveryLookupClient {
    private final String environment;
    private final Provider<URI> discoveryServiceURI;
    private final NodeInfo nodeInfo;
    private final JsonCodec<ServiceDescriptorsRepresentation> serviceDescriptorsCodec;
    private final HttpClient httpClient;

    @Inject
    public HttpDiscoveryLookupClient(@ForDiscoveryClient Provider<URI> discoveryServiceURI, NodeInfo nodeInfo, JsonCodec<ServiceDescriptorsRepresentation> serviceDescriptorsCodec, @ForDiscoveryClient HttpClient httpClient) {
        Objects.requireNonNull(discoveryServiceURI, "discoveryServiceURI is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(serviceDescriptorsCodec, "serviceDescriptorsCodec is null");
        Objects.requireNonNull(httpClient, "httpClient is null");
        this.nodeInfo = nodeInfo;
        this.environment = nodeInfo.getEnvironment();
        this.discoveryServiceURI = discoveryServiceURI;
        this.serviceDescriptorsCodec = serviceDescriptorsCodec;
        this.httpClient = httpClient;
    }

    @Flatten
    @Managed
    public RequestStats getStats() {
        return this.httpClient.getStats();
    }

    @Override
    public ListenableFuture<ServiceDescriptors> getServices(String type) {
        Objects.requireNonNull(type, "type is null");
        return this.lookup(type, null, null);
    }

    @Override
    public ListenableFuture<ServiceDescriptors> getServices(String type, String pool) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(pool, "pool is null");
        return this.lookup(type, pool, null);
    }

    @Override
    public ListenableFuture<ServiceDescriptors> refreshServices(ServiceDescriptors serviceDescriptors) {
        Objects.requireNonNull(serviceDescriptors, "serviceDescriptors is null");
        return this.lookup(serviceDescriptors.getType(), serviceDescriptors.getPool(), serviceDescriptors);
    }

    private ListenableFuture<ServiceDescriptors> lookup(final String type, final String pool, final ServiceDescriptors serviceDescriptors) {
        Objects.requireNonNull(type, "type is null");
        URI uri = (URI)this.discoveryServiceURI.get();
        if (uri == null) {
            return Futures.immediateFailedFuture((Throwable)new DiscoveryException("No discovery servers are available"));
        }
        uri = URI.create(uri + "/v1/service/" + type + "/");
        if (pool != null) {
            uri = uri.resolve(pool);
        }
        Request.Builder requestBuilder = Request.Builder.prepareGet().setUri(uri).setHeader("User-Agent", this.nodeInfo.getNodeId());
        if (serviceDescriptors != null && serviceDescriptors.getETag() != null) {
            requestBuilder.setHeader("ETag", serviceDescriptors.getETag());
        }
        return this.httpClient.executeAsync(requestBuilder.build(), (ResponseHandler)new DiscoveryResponseHandler<ServiceDescriptors>(String.format("Lookup of %s", type), uri){

            @Override
            public ServiceDescriptors handle(Request request, Response response) {
                byte[] json;
                Duration maxAge = HttpDiscoveryLookupClient.this.extractMaxAge(response);
                String eTag = response.getHeader("ETag");
                if (HttpStatus.NOT_MODIFIED.code() == response.getStatusCode() && serviceDescriptors != null) {
                    return new ServiceDescriptors(serviceDescriptors, maxAge, eTag);
                }
                if (HttpStatus.OK.code() != response.getStatusCode()) {
                    throw new DiscoveryException(String.format("Lookup of %s failed with status code %s", type, response.getStatusCode()));
                }
                try {
                    json = ByteStreams.toByteArray((InputStream)response.getInputStream());
                }
                catch (IOException e) {
                    throw new DiscoveryException(String.format("Lookup of %s failed", type), e);
                }
                ServiceDescriptorsRepresentation serviceDescriptorsRepresentation = (ServiceDescriptorsRepresentation)HttpDiscoveryLookupClient.this.serviceDescriptorsCodec.fromJson(json);
                if (!HttpDiscoveryLookupClient.this.environment.equals(serviceDescriptorsRepresentation.getEnvironment())) {
                    throw new DiscoveryException(String.format("Expected environment to be %s, but was %s", HttpDiscoveryLookupClient.this.environment, serviceDescriptorsRepresentation.getEnvironment()));
                }
                return new ServiceDescriptors(type, pool, serviceDescriptorsRepresentation.getServiceDescriptors(), maxAge, eTag);
            }
        });
    }

    private Duration extractMaxAge(Response response) {
        CacheControl cacheControl;
        String header = response.getHeader("Cache-Control");
        if (header != null && (cacheControl = CacheControl.valueOf((String)header)).getMaxAge() > 0) {
            return new Duration((double)cacheControl.getMaxAge(), TimeUnit.SECONDS);
        }
        return DiscoveryAnnouncementClient.DEFAULT_DELAY;
    }

    private class DiscoveryResponseHandler<T>
    implements ResponseHandler<T, DiscoveryException> {
        private final String name;
        private final URI uri;

        protected DiscoveryResponseHandler(String name, URI uri) {
            this.name = name;
            this.uri = uri;
        }

        public T handle(Request request, Response response) {
            return null;
        }

        public final T handleException(Request request, Exception exception) {
            if (exception instanceof InterruptedException) {
                throw new DiscoveryException(this.name + " was interrupted for " + this.uri);
            }
            if (exception instanceof CancellationException) {
                throw new DiscoveryException(this.name + " was canceled for " + this.uri);
            }
            if (exception instanceof DiscoveryException) {
                throw (DiscoveryException)exception;
            }
            throw new DiscoveryException(this.name + " failed for " + this.uri, exception);
        }
    }
}

