/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector;

import com.facebook.presto.connector.ConnectorAwareNodeManager;
import com.facebook.presto.connector.ConnectorContextInstance;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.connector.informationSchema.InformationSchemaConnector;
import com.facebook.presto.connector.system.DelegatingSystemTablesProvider;
import com.facebook.presto.connector.system.MetadataBasedSystemTablesProvider;
import com.facebook.presto.connector.system.StaticSystemTablesProvider;
import com.facebook.presto.connector.system.SystemConnector;
import com.facebook.presto.connector.system.SystemTablesProvider;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorIndexProvider;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.RecordPageSourceProvider;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class ConnectorManager {
    private static final Logger log = Logger.get(ConnectorManager.class);
    private final MetadataManager metadataManager;
    private final CatalogManager catalogManager;
    private final AccessControlManager accessControlManager;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final HandleResolver handleResolver;
    private final InternalNodeManager nodeManager;
    private final TypeManager typeManager;
    private final PageSorter pageSorter;
    private final PageIndexerFactory pageIndexerFactory;
    private final NodeInfo nodeInfo;
    private final TransactionManager transactionManager;
    @GuardedBy(value="this")
    private final ConcurrentMap<String, ConnectorFactory> connectorFactories = new ConcurrentHashMap<String, ConnectorFactory>();
    @GuardedBy(value="this")
    private final ConcurrentMap<ConnectorId, MaterializedConnector> connectors = new ConcurrentHashMap<ConnectorId, MaterializedConnector>();
    private final AtomicBoolean stopped = new AtomicBoolean();

    @Inject
    public ConnectorManager(MetadataManager metadataManager, CatalogManager catalogManager, AccessControlManager accessControlManager, SplitManager splitManager, PageSourceManager pageSourceManager, IndexManager indexManager, NodePartitioningManager nodePartitioningManager, PageSinkManager pageSinkManager, HandleResolver handleResolver, InternalNodeManager nodeManager, NodeInfo nodeInfo, TypeManager typeManager, PageSorter pageSorter, PageIndexerFactory pageIndexerFactory, TransactionManager transactionManager) {
        this.metadataManager = metadataManager;
        this.catalogManager = catalogManager;
        this.accessControlManager = accessControlManager;
        this.splitManager = splitManager;
        this.pageSourceManager = pageSourceManager;
        this.indexManager = indexManager;
        this.nodePartitioningManager = nodePartitioningManager;
        this.pageSinkManager = pageSinkManager;
        this.handleResolver = handleResolver;
        this.nodeManager = nodeManager;
        this.typeManager = typeManager;
        this.pageSorter = pageSorter;
        this.pageIndexerFactory = pageIndexerFactory;
        this.nodeInfo = nodeInfo;
        this.transactionManager = transactionManager;
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        for (Map.Entry entry : this.connectors.entrySet()) {
            Connector connector = ((MaterializedConnector)entry.getValue()).getConnector();
            try {
                ThreadContextClassLoader ignored = new ThreadContextClassLoader(connector.getClass().getClassLoader());
                Throwable throwable = null;
                try {
                    connector.shutdown();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            catch (Throwable t) {
                log.error(t, "Error shutting down connector: %s", new Object[]{entry.getKey()});
            }
        }
    }

    public synchronized void addConnectorFactory(ConnectorFactory connectorFactory) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        ConnectorFactory existingConnectorFactory = this.connectorFactories.putIfAbsent(connectorFactory.getName(), connectorFactory);
        Preconditions.checkArgument((existingConnectorFactory == null ? 1 : 0) != 0, (String)"Connector %s is already registered", (Object)connectorFactory.getName());
        this.handleResolver.addConnectorName(connectorFactory.getName(), connectorFactory.getHandleResolver());
    }

    public synchronized ConnectorId createConnection(String catalogName, String connectorName, Map<String, String> properties) {
        Objects.requireNonNull(connectorName, "connectorName is null");
        ConnectorFactory connectorFactory = (ConnectorFactory)this.connectorFactories.get(connectorName);
        Preconditions.checkArgument((connectorFactory != null ? 1 : 0) != 0, (String)"No factory for connector %s", (Object)connectorName);
        return this.createConnection(catalogName, connectorFactory, properties);
    }

    private synchronized ConnectorId createConnection(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(properties, "properties is null");
        Objects.requireNonNull(connectorFactory, "connectorFactory is null");
        Preconditions.checkArgument((!this.catalogManager.getCatalog(catalogName).isPresent() ? 1 : 0) != 0, (String)"A catalog already exists for %s", (Object)catalogName);
        ConnectorId connectorId = new ConnectorId(catalogName);
        Preconditions.checkState((!this.connectors.containsKey(connectorId) ? 1 : 0) != 0, (String)"A connector %s already exists", (Object)connectorId);
        this.addCatalogConnector(catalogName, connectorId, connectorFactory, properties);
        return connectorId;
    }

    private synchronized void addCatalogConnector(String catalogName, ConnectorId connectorId, ConnectorFactory factory, Map<String, String> properties) {
        MaterializedConnector connector = new MaterializedConnector(connectorId, this.createConnector(connectorId, factory, properties));
        MaterializedConnector informationSchemaConnector = new MaterializedConnector(ConnectorId.createInformationSchemaConnectorId(connectorId), new InformationSchemaConnector(catalogName, this.nodeManager, this.metadataManager, this.accessControlManager));
        ConnectorId systemId = ConnectorId.createSystemTablesConnectorId(connectorId);
        SystemTablesProvider systemTablesProvider = this.nodeManager.getCurrentNode().isCoordinator() ? new DelegatingSystemTablesProvider(new StaticSystemTablesProvider(connector.getSystemTables()), new MetadataBasedSystemTablesProvider(this.metadataManager, catalogName)) : new StaticSystemTablesProvider(connector.getSystemTables());
        MaterializedConnector systemConnector = new MaterializedConnector(systemId, new SystemConnector(systemId, this.nodeManager, systemTablesProvider, transactionId -> this.transactionManager.getConnectorTransaction((TransactionId)transactionId, connectorId)));
        Catalog catalog = new Catalog(catalogName, connector.getConnectorId(), connector.getConnector(), informationSchemaConnector.getConnectorId(), informationSchemaConnector.getConnector(), systemConnector.getConnectorId(), systemConnector.getConnector());
        try {
            this.addConnectorInternal(connector);
            this.addConnectorInternal(informationSchemaConnector);
            this.addConnectorInternal(systemConnector);
            this.catalogManager.registerCatalog(catalog);
        }
        catch (Throwable e) {
            this.catalogManager.removeCatalog(catalog.getCatalogName());
            this.removeConnectorInternal(systemConnector.getConnectorId());
            this.removeConnectorInternal(informationSchemaConnector.getConnectorId());
            this.removeConnectorInternal(connector.getConnectorId());
            throw e;
        }
    }

    private synchronized void addConnectorInternal(MaterializedConnector connector) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        ConnectorId connectorId = connector.getConnectorId();
        Preconditions.checkState((!this.connectors.containsKey(connectorId) ? 1 : 0) != 0, (String)"A connector %s already exists", (Object)connectorId);
        this.connectors.put(connectorId, connector);
        this.splitManager.addConnectorSplitManager(connectorId, connector.getSplitManager());
        this.pageSourceManager.addConnectorPageSourceProvider(connectorId, connector.getPageSourceProvider());
        connector.getPageSinkProvider().ifPresent(pageSinkProvider -> this.pageSinkManager.addConnectorPageSinkProvider(connectorId, (ConnectorPageSinkProvider)pageSinkProvider));
        connector.getIndexProvider().ifPresent(indexProvider -> this.indexManager.addIndexProvider(connectorId, (ConnectorIndexProvider)indexProvider));
        connector.getPartitioningProvider().ifPresent(partitioningProvider -> this.nodePartitioningManager.addPartitioningProvider(connectorId, (ConnectorNodePartitioningProvider)partitioningProvider));
        this.metadataManager.getProcedureRegistry().addProcedures(connectorId, connector.getProcedures());
        connector.getAccessControl().ifPresent(accessControl -> this.accessControlManager.addCatalogAccessControl(connectorId, (ConnectorAccessControl)accessControl));
        this.metadataManager.getTablePropertyManager().addProperties(connectorId, connector.getTableProperties());
        this.metadataManager.getColumnPropertyManager().addProperties(connectorId, connector.getColumnProperties());
        this.metadataManager.getSchemaPropertyManager().addProperties(connectorId, connector.getSchemaProperties());
        this.metadataManager.getSessionPropertyManager().addConnectorSessionProperties(connectorId, connector.getSessionProperties());
    }

    public synchronized void dropConnection(String catalogName) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.catalogManager.removeCatalog(catalogName).ifPresent(connectorId -> {
            this.removeConnectorInternal((ConnectorId)connectorId);
            this.removeConnectorInternal(ConnectorId.createInformationSchemaConnectorId(connectorId));
            this.removeConnectorInternal(ConnectorId.createSystemTablesConnectorId(connectorId));
        });
    }

    private synchronized void removeConnectorInternal(ConnectorId connectorId) {
        this.splitManager.removeConnectorSplitManager(connectorId);
        this.pageSourceManager.removeConnectorPageSourceProvider(connectorId);
        this.pageSinkManager.removeConnectorPageSinkProvider(connectorId);
        this.indexManager.removeIndexProvider(connectorId);
        this.nodePartitioningManager.removePartitioningProvider(connectorId);
        this.metadataManager.getProcedureRegistry().removeProcedures(connectorId);
        this.accessControlManager.removeCatalogAccessControl(connectorId);
        this.metadataManager.getTablePropertyManager().removeProperties(connectorId);
        this.metadataManager.getSchemaPropertyManager().removeProperties(connectorId);
        this.metadataManager.getSessionPropertyManager().removeConnectorSessionProperties(connectorId);
        MaterializedConnector materializedConnector = (MaterializedConnector)this.connectors.remove(connectorId);
        if (materializedConnector != null) {
            Connector connector = materializedConnector.getConnector();
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(connector.getClass().getClassLoader());){
                connector.shutdown();
            }
            catch (Throwable t) {
                log.error(t, "Error shutting down connector: %s", new Object[]{connectorId});
            }
        }
    }

    private Connector createConnector(ConnectorId connectorId, ConnectorFactory factory, Map<String, String> properties) {
        ConnectorContextInstance context = new ConnectorContextInstance(new ConnectorAwareNodeManager(this.nodeManager, this.nodeInfo.getEnvironment(), connectorId), this.typeManager, this.pageSorter, this.pageIndexerFactory);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            Connector connector = factory.create(connectorId.getCatalogName(), properties, (ConnectorContext)context);
            return connector;
        }
    }

    private static class MaterializedConnector {
        private final ConnectorId connectorId;
        private final Connector connector;
        private final ConnectorSplitManager splitManager;
        private final Set<SystemTable> systemTables;
        private final Set<Procedure> procedures;
        private final ConnectorPageSourceProvider pageSourceProvider;
        private final Optional<ConnectorPageSinkProvider> pageSinkProvider;
        private final Optional<ConnectorIndexProvider> indexProvider;
        private final Optional<ConnectorNodePartitioningProvider> partitioningProvider;
        private final Optional<ConnectorAccessControl> accessControl;
        private final List<PropertyMetadata<?>> sessionProperties;
        private final List<PropertyMetadata<?>> tableProperties;
        private final List<PropertyMetadata<?>> schemaProperties;
        private final List<PropertyMetadata<?>> columnProperties;

        public MaterializedConnector(ConnectorId connectorId, Connector connector) {
            this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
            this.connector = Objects.requireNonNull(connector, "connector is null");
            this.splitManager = connector.getSplitManager();
            Preconditions.checkState((this.splitManager != null ? 1 : 0) != 0, (String)"Connector %s does not have a split manager", (Object)connectorId);
            Set systemTables = connector.getSystemTables();
            Objects.requireNonNull(systemTables, "Connector %s returned a null system tables set");
            this.systemTables = ImmutableSet.copyOf((Collection)systemTables);
            Set procedures = connector.getProcedures();
            Objects.requireNonNull(procedures, "Connector %s returned a null procedures set");
            this.procedures = ImmutableSet.copyOf((Collection)procedures);
            ConnectorPageSourceProvider connectorPageSourceProvider = null;
            try {
                connectorPageSourceProvider = connector.getPageSourceProvider();
                Objects.requireNonNull(connectorPageSourceProvider, String.format("Connector %s returned a null page source provider", connectorId));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (connectorPageSourceProvider == null) {
                ConnectorRecordSetProvider connectorRecordSetProvider = null;
                try {
                    connectorRecordSetProvider = connector.getRecordSetProvider();
                    Objects.requireNonNull(connectorRecordSetProvider, String.format("Connector %s returned a null record set provider", connectorId));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                Preconditions.checkState((connectorRecordSetProvider != null ? 1 : 0) != 0, (String)"Connector %s has neither a PageSource or RecordSet provider", (Object)connectorId);
                connectorPageSourceProvider = new RecordPageSourceProvider(connectorRecordSetProvider);
            }
            this.pageSourceProvider = connectorPageSourceProvider;
            ConnectorPageSinkProvider connectorPageSinkProvider = null;
            try {
                connectorPageSinkProvider = connector.getPageSinkProvider();
                Objects.requireNonNull(connectorPageSinkProvider, String.format("Connector %s returned a null page sink provider", connectorId));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.pageSinkProvider = Optional.ofNullable(connectorPageSinkProvider);
            ConnectorIndexProvider indexProvider = null;
            try {
                indexProvider = connector.getIndexProvider();
                Objects.requireNonNull(indexProvider, String.format("Connector %s returned a null index provider", connectorId));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.indexProvider = Optional.ofNullable(indexProvider);
            ConnectorNodePartitioningProvider partitioningProvider = null;
            try {
                partitioningProvider = connector.getNodePartitioningProvider();
                Objects.requireNonNull(partitioningProvider, String.format("Connector %s returned a null partitioning provider", connectorId));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.partitioningProvider = Optional.ofNullable(partitioningProvider);
            ConnectorAccessControl accessControl = null;
            try {
                accessControl = connector.getAccessControl();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.accessControl = Optional.ofNullable(accessControl);
            List sessionProperties = connector.getSessionProperties();
            Objects.requireNonNull(sessionProperties, "Connector %s returned a null system properties set");
            this.sessionProperties = ImmutableList.copyOf((Collection)sessionProperties);
            List tableProperties = connector.getTableProperties();
            Objects.requireNonNull(tableProperties, "Connector %s returned a null table properties set");
            this.tableProperties = ImmutableList.copyOf((Collection)tableProperties);
            List schemaProperties = connector.getSchemaProperties();
            Objects.requireNonNull(schemaProperties, "Connector %s returned a null schema properties set");
            this.schemaProperties = ImmutableList.copyOf((Collection)schemaProperties);
            List columnProperties = connector.getColumnProperties();
            Objects.requireNonNull(columnProperties, "Connector %s returned a null column properties set");
            this.columnProperties = ImmutableList.copyOf((Collection)columnProperties);
        }

        public ConnectorId getConnectorId() {
            return this.connectorId;
        }

        public Connector getConnector() {
            return this.connector;
        }

        public ConnectorSplitManager getSplitManager() {
            return this.splitManager;
        }

        public Set<SystemTable> getSystemTables() {
            return this.systemTables;
        }

        public Set<Procedure> getProcedures() {
            return this.procedures;
        }

        public ConnectorPageSourceProvider getPageSourceProvider() {
            return this.pageSourceProvider;
        }

        public Optional<ConnectorPageSinkProvider> getPageSinkProvider() {
            return this.pageSinkProvider;
        }

        public Optional<ConnectorIndexProvider> getIndexProvider() {
            return this.indexProvider;
        }

        public Optional<ConnectorNodePartitioningProvider> getPartitioningProvider() {
            return this.partitioningProvider;
        }

        public Optional<ConnectorAccessControl> getAccessControl() {
            return this.accessControl;
        }

        public List<PropertyMetadata<?>> getSessionProperties() {
            return this.sessionProperties;
        }

        public List<PropertyMetadata<?>> getTableProperties() {
            return this.tableProperties;
        }

        public List<PropertyMetadata<?>> getColumnProperties() {
            return this.columnProperties;
        }

        public List<PropertyMetadata<?>> getSchemaProperties() {
            return this.schemaProperties;
        }
    }
}

