/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.connector.system.SystemColumnHandle;
import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.connector.system.SystemTableLayoutHandle;
import com.facebook.presto.connector.system.SystemTablesProvider;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SystemTablesMetadata
implements ConnectorMetadata {
    private final ConnectorId connectorId;
    private final SystemTablesProvider tables;

    public SystemTablesMetadata(ConnectorId connectorId, SystemTablesProvider tables) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId");
        this.tables = Objects.requireNonNull(tables, "tables is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.tables.listSystemTables(session).stream().map(table -> table.getTableMetadata().getTable().getSchemaName()).distinct().collect(ImmutableList.toImmutableList());
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Optional<SystemTable> table = this.tables.getSystemTable(session, tableName);
        if (!table.isPresent()) {
            return null;
        }
        return SystemTableHandle.fromSchemaTableName(this.connectorId, tableName);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        SystemTableHandle tableHandle = (SystemTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new SystemTableLayoutHandle(tableHandle.getConnectorId(), tableHandle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.checkAndGetTable(session, tableHandle).getTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        return (List)this.tables.listSystemTables(session).stream().map(SystemTable::getTableMetadata).map(ConnectorTableMetadata::getTable).filter(table -> schemaNameOrNull == null || table.getSchemaName().equals(schemaNameOrNull)).collect(ImmutableList.toImmutableList());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        String columnName;
        ConnectorTableMetadata tableMetadata = this.checkAndGetTable(session, tableHandle).getTableMetadata();
        ColumnMetadata columnMetadata = MetadataUtil.findColumnMetadata(tableMetadata, columnName = ((SystemColumnHandle)columnHandle).getColumnName());
        Preconditions.checkArgument((columnMetadata != null ? 1 : 0) != 0, (String)"Column %s on table %s does not exist", (Object)columnName, (Object)tableMetadata.getTable());
        return columnMetadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ConnectorTableMetadata tableMetadata = this.checkAndGetTable(session, tableHandle).getTableMetadata();
        return SystemColumnHandle.toSystemColumnHandles(((SystemTableHandle)tableHandle).getConnectorId(), tableMetadata);
    }

    private SystemTable checkAndGetTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SystemTableHandle systemTableHandle = (SystemTableHandle)tableHandle;
        return this.tables.getSystemTable(session, systemTableHandle.getSchemaTableName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table %s not found", systemTableHandle.getSchemaTableName())));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        if (prefix.getTableName() != null) {
            SchemaTableName tableName = prefix.toSchemaTableName();
            return this.tables.getSystemTable(session, tableName).map(systemTable -> Collections.singletonMap(tableName, systemTable.getTableMetadata().getColumns())).orElseGet(ImmutableMap::of);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SystemTable table : this.tables.listSystemTables(session)) {
            ConnectorTableMetadata tableMetadata = table.getTableMetadata();
            if (!prefix.matches(tableMetadata.getTable())) continue;
            builder.put((Object)tableMetadata.getTable(), (Object)tableMetadata.getColumns());
        }
        return builder.build();
    }
}

