/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.transaction.TransactionId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.Function;

public class SystemTransactionHandle
implements ConnectorTransactionHandle {
    private final ConnectorId connectorId;
    private final TransactionId transactionId;
    private final Supplier<ConnectorTransactionHandle> connectorTransactionHandle;

    SystemTransactionHandle(ConnectorId connectorId, TransactionId transactionId, Function<TransactionId, ConnectorTransactionHandle> transactionHandleFunction) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        Objects.requireNonNull(transactionHandleFunction, "transactionHandleFunction is null");
        this.connectorTransactionHandle = Suppliers.memoize(() -> (ConnectorTransactionHandle)transactionHandleFunction.apply(transactionId));
    }

    @JsonCreator
    public SystemTransactionHandle(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="transactionId") TransactionId transactionId, @JsonProperty(value="connectorTransactionHandle") ConnectorTransactionHandle connectorTransactionHandle) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        Objects.requireNonNull(connectorTransactionHandle, "connectorTransactionHandle is null");
        this.connectorTransactionHandle = () -> connectorTransactionHandle;
    }

    @JsonProperty
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty
    public ConnectorTransactionHandle getConnectorTransactionHandle() {
        return (ConnectorTransactionHandle)this.connectorTransactionHandle.get();
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.transactionId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SystemTransactionHandle other = (SystemTransactionHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.transactionId, other.transactionId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("transactionHandle", (Object)this.transactionId).toString();
    }
}

