/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.node.NodeInfo;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class TaskSystemTable
implements SystemTable {
    public static final SchemaTableName TASK_TABLE_NAME = new SchemaTableName("runtime", "tasks");
    public static final ConnectorTableMetadata TASK_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TASK_TABLE_NAME).column("node_id", (Type)VarcharType.createUnboundedVarcharType()).column("task_id", (Type)VarcharType.createUnboundedVarcharType()).column("stage_id", (Type)VarcharType.createUnboundedVarcharType()).column("query_id", (Type)VarcharType.createUnboundedVarcharType()).column("state", (Type)VarcharType.createUnboundedVarcharType()).column("splits", (Type)BigintType.BIGINT).column("queued_splits", (Type)BigintType.BIGINT).column("running_splits", (Type)BigintType.BIGINT).column("completed_splits", (Type)BigintType.BIGINT).column("split_scheduled_time_ms", (Type)BigintType.BIGINT).column("split_cpu_time_ms", (Type)BigintType.BIGINT).column("split_blocked_time_ms", (Type)BigintType.BIGINT).column("raw_input_bytes", (Type)BigintType.BIGINT).column("raw_input_rows", (Type)BigintType.BIGINT).column("processed_input_bytes", (Type)BigintType.BIGINT).column("processed_input_rows", (Type)BigintType.BIGINT).column("output_bytes", (Type)BigintType.BIGINT).column("output_rows", (Type)BigintType.BIGINT).column("physical_written_bytes", (Type)BigintType.BIGINT).column("created", (Type)TimestampType.TIMESTAMP).column("start", (Type)TimestampType.TIMESTAMP).column("last_heartbeat", (Type)TimestampType.TIMESTAMP).column("end", (Type)TimestampType.TIMESTAMP).build();
    private final TaskManager taskManager;
    private final String nodeId;

    @Inject
    public TaskSystemTable(TaskManager taskManager, NodeInfo nodeInfo) {
        this.taskManager = taskManager;
        this.nodeId = nodeInfo.getNodeId();
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.ALL_NODES;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return TASK_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)TASK_TABLE);
        for (TaskInfo taskInfo : this.taskManager.getAllTaskInfo()) {
            TaskStats stats = taskInfo.getStats();
            TaskStatus taskStatus = taskInfo.getTaskStatus();
            table.addRow(new Object[]{this.nodeId, taskStatus.getTaskId().toString(), taskStatus.getTaskId().getStageId().toString(), taskStatus.getTaskId().getQueryId().toString(), taskStatus.getState().toString(), (long)stats.getTotalDrivers(), (long)stats.getQueuedDrivers(), (long)stats.getRunningDrivers(), (long)stats.getCompletedDrivers(), TaskSystemTable.toMillis(stats.getTotalScheduledTime()), TaskSystemTable.toMillis(stats.getTotalCpuTime()), TaskSystemTable.toMillis(stats.getTotalBlockedTime()), TaskSystemTable.toBytes(stats.getRawInputDataSize()), stats.getRawInputPositions(), TaskSystemTable.toBytes(stats.getProcessedInputDataSize()), stats.getProcessedInputPositions(), TaskSystemTable.toBytes(stats.getOutputDataSize()), stats.getOutputPositions(), TaskSystemTable.toBytes(stats.getPhysicalWrittenDataSize()), TaskSystemTable.toTimeStamp(stats.getCreateTime()), TaskSystemTable.toTimeStamp(stats.getFirstStartTime()), TaskSystemTable.toTimeStamp(taskInfo.getLastHeartbeat()), TaskSystemTable.toTimeStamp(stats.getEndTime())});
        }
        return table.build().cursor();
    }

    private static Long toMillis(Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toMillis();
    }

    private static Long toBytes(DataSize dataSize) {
        if (dataSize == null) {
            return null;
        }
        return dataSize.toBytes();
    }

    private static Long toTimeStamp(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.getMillis();
    }
}

