/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Memo;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.base.Verify;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class CachingStatsProvider
implements StatsProvider {
    private final StatsCalculator statsCalculator;
    private final Optional<Memo> memo;
    private final Lookup lookup;
    private final Session session;
    private final TypeProvider types;
    private final Map<PlanNode, PlanNodeStatsEstimate> cache = new IdentityHashMap<PlanNode, PlanNodeStatsEstimate>();

    public CachingStatsProvider(StatsCalculator statsCalculator, Session session, TypeProvider types) {
        this(statsCalculator, Optional.empty(), Lookup.noLookup(), session, types);
    }

    public CachingStatsProvider(StatsCalculator statsCalculator, Optional<Memo> memo, Lookup lookup, Session session, TypeProvider types) {
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.memo = Objects.requireNonNull(memo, "memo is null");
        this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.types = Objects.requireNonNull(types, "types is null");
    }

    @Override
    public PlanNodeStatsEstimate getStats(PlanNode node) {
        Objects.requireNonNull(node, "node is null");
        if (node instanceof GroupReference) {
            return this.getGroupStats((GroupReference)node);
        }
        PlanNodeStatsEstimate stats = this.cache.get(node);
        if (stats != null) {
            return stats;
        }
        stats = this.statsCalculator.calculateStats(node, this, this.lookup, this.session, this.types);
        Verify.verify((this.cache.put(node, stats) == null ? 1 : 0) != 0, (String)"Stats already set", (Object[])new Object[0]);
        return stats;
    }

    private PlanNodeStatsEstimate getGroupStats(GroupReference groupReference) {
        int group = groupReference.getGroupId();
        Memo memo = this.memo.orElseThrow(() -> new IllegalStateException("CachingStatsProvider without memo cannot handle GroupReferences"));
        Optional<PlanNodeStatsEstimate> stats = memo.getStats(group);
        if (stats.isPresent()) {
            return stats.get();
        }
        PlanNodeStatsEstimate groupStats = this.statsCalculator.calculateStats(memo.getNode(group), this, this.lookup, this.session, this.types);
        Verify.verify((!memo.getStats(group).isPresent() ? 1 : 0) != 0, (String)"Group stats already set", (Object[])new Object[0]);
        memo.storeStats(group, groupStats);
        return groupStats;
    }
}

