/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanNodeCostEstimate;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.util.Objects;
import javax.inject.Inject;

public class CostComparator {
    private final double cpuWeight;
    private final double memoryWeight;
    private final double networkWeight;

    @Inject
    public CostComparator(FeaturesConfig featuresConfig) {
        this(featuresConfig.getCpuCostWeight(), featuresConfig.getMemoryCostWeight(), featuresConfig.getNetworkCostWeight());
    }

    @VisibleForTesting
    public CostComparator(double cpuWeight, double memoryWeight, double networkWeight) {
        Preconditions.checkArgument((cpuWeight >= 0.0 ? 1 : 0) != 0, (Object)"cpuWeight cannot be negative");
        Preconditions.checkArgument((memoryWeight >= 0.0 ? 1 : 0) != 0, (Object)"memoryWeight cannot be negative");
        Preconditions.checkArgument((networkWeight >= 0.0 ? 1 : 0) != 0, (Object)"networkWeight cannot be negative");
        this.cpuWeight = cpuWeight;
        this.memoryWeight = memoryWeight;
        this.networkWeight = networkWeight;
    }

    public Ordering<PlanNodeCostEstimate> forSession(Session session) {
        Objects.requireNonNull(session, "session is null");
        return Ordering.from((left, right) -> this.compare(session, (PlanNodeCostEstimate)left, (PlanNodeCostEstimate)right));
    }

    public int compare(Session session, PlanNodeCostEstimate left, PlanNodeCostEstimate right) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        Preconditions.checkArgument((!left.hasUnknownComponents() && !right.hasUnknownComponents() ? 1 : 0) != 0, (Object)"cannot compare unknown costs");
        double leftCost = left.getCpuCost() * this.cpuWeight + left.getMemoryCost() * this.memoryWeight + left.getNetworkCost() * this.networkWeight;
        double rightCost = right.getCpuCost() * this.cpuWeight + right.getMemoryCost() * this.memoryWeight + right.getNetworkCost() * this.networkWeight;
        return Double.compare(leftCost, rightCost);
    }
}

