/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostCalculatorUsingExchanges;
import com.facebook.presto.cost.FragmentedPlanSourceProvider;
import com.facebook.presto.cost.PlanNodeCostEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import java.util.Objects;
import java.util.function.IntSupplier;

public class FragmentedPlanCostCalculator
implements CostCalculator {
    private final CostCalculator delegate;
    private final FragmentedPlanSourceProvider sourceProvider;
    private final IntSupplier numberOfNodes;

    public FragmentedPlanCostCalculator(FragmentedPlanSourceProvider sourceProvider, CostCalculator delegate, InternalNodeManager nodeManager, NodeSchedulerConfig nodeSchedulerConfig) {
        this(delegate, sourceProvider, CostCalculatorUsingExchanges.currentNumberOfWorkerNodes(nodeSchedulerConfig.isIncludeCoordinator(), nodeManager));
    }

    public FragmentedPlanCostCalculator(CostCalculator delegate, FragmentedPlanSourceProvider sourceProvider, IntSupplier numberOfNodes) {
        this.sourceProvider = Objects.requireNonNull(sourceProvider, "sourceProvider is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.numberOfNodes = Objects.requireNonNull(numberOfNodes, "numberOfNodes is null");
    }

    @Override
    public PlanNodeCostEstimate calculateCost(PlanNode node, StatsProvider stats, Lookup lookup, Session session, TypeProvider types) {
        if (node instanceof RemoteSourceNode) {
            return this.calculateRemoteSourceNodeCost((RemoteSourceNode)node, stats, types);
        }
        return this.delegate.calculateCost(node, stats, lookup, session, types);
    }

    private PlanNodeCostEstimate calculateRemoteSourceNodeCost(RemoteSourceNode node, StatsProvider stats, TypeProvider types) {
        PlanNodeCostEstimate costEstimate = PlanNodeCostEstimate.ZERO_COST;
        ExchangeNode.Type exchangeType = node.getExchangeType();
        for (PlanNode source : this.sourceProvider.getSources(node)) {
            PlanNodeCostEstimate exchangeCost = CostCalculatorUsingExchanges.calculateExchangeCost(this.numberOfNodes.getAsInt(), stats.getStats(source), node.getOutputSymbols(), exchangeType, ExchangeNode.Scope.REMOTE, types);
            costEstimate.add(exchangeCost);
        }
        return costEstimate;
    }
}

