/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.PlanNodeSourceProvider;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FragmentedPlanSourceProvider
implements PlanNodeSourceProvider {
    private final Map<PlanFragmentId, PlanFragment> fragments;

    public static FragmentedPlanSourceProvider create(List<PlanFragment> planFragments) {
        Map fragmentIdPlanNodeMap = (Map)planFragments.stream().collect(ImmutableMap.toImmutableMap(PlanFragment::getId, fragment -> fragment));
        return new FragmentedPlanSourceProvider(fragmentIdPlanNodeMap);
    }

    private FragmentedPlanSourceProvider(Map<PlanFragmentId, PlanFragment> fragments) {
        this.fragments = ImmutableMap.copyOf(Objects.requireNonNull(fragments, "fragments is null"));
    }

    @Override
    public List<PlanNode> getSources(PlanNode node) {
        if (node instanceof RemoteSourceNode) {
            return (List)((RemoteSourceNode)node).getSourceFragmentIds().stream().map(id -> {
                Verify.verify((boolean)this.fragments.containsKey(id), (String)"fragment id not in map: %s", (Object)id);
                return this.fragments.get(id).getRoot();
            }).collect(ImmutableList.toImmutableList());
        }
        return node.getSources();
    }

    public List<PlanFragment> getSourceFragments(RemoteSourceNode node) {
        return (List)node.getSourceFragmentIds().stream().map(id -> {
            Verify.verify((boolean)this.fragments.containsKey(id), (String)"fragment id not in map: %s", (Object)id);
            return this.fragments.get(id);
        }).collect(ImmutableList.toImmutableList());
    }
}

