/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.FragmentedPlanSourceProvider;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimateMath;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.List;
import java.util.Objects;

public class FragmentedPlanStatsCalculator
implements StatsCalculator {
    private final StatsCalculator delegate;
    private final FragmentedPlanSourceProvider sourceProvider;

    public FragmentedPlanStatsCalculator(StatsCalculator delegate, FragmentedPlanSourceProvider sourceProvider) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.sourceProvider = Objects.requireNonNull(sourceProvider, "source provider is null");
    }

    @Override
    public PlanNodeStatsEstimate calculateStats(PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        if (node instanceof RemoteSourceNode) {
            return this.calculateRemoteSourceStats((RemoteSourceNode)node, sourceStats);
        }
        return this.delegate.calculateStats(node, sourceStats, lookup, session, types);
    }

    private PlanNodeStatsEstimate calculateRemoteSourceStats(RemoteSourceNode node, StatsProvider statsProvider) {
        PlanNodeStatsEstimate estimate = null;
        for (PlanFragment sourceFragment : this.sourceProvider.getSourceFragments(node)) {
            PlanNodeStatsEstimate sourceStatsWithMappedSymbols = this.mapToOutputSymbols(statsProvider.getStats(sourceFragment.getRoot()), sourceFragment.getPartitioningScheme().getOutputLayout(), node.getOutputSymbols());
            if (estimate != null) {
                estimate = PlanNodeStatsEstimateMath.addStatsAndMaxDistinctValues(estimate, sourceStatsWithMappedSymbols);
                continue;
            }
            estimate = sourceStatsWithMappedSymbols;
        }
        Verify.verify((estimate != null ? 1 : 0) != 0, (String)"estimate is null", (Object[])new Object[0]);
        return estimate;
    }

    private PlanNodeStatsEstimate mapToOutputSymbols(PlanNodeStatsEstimate estimate, List<Symbol> inputs, List<Symbol> outputs) {
        Preconditions.checkArgument((inputs.size() == outputs.size() ? 1 : 0) != 0, (Object)"Input symbols count does not match output symbols count");
        PlanNodeStatsEstimate.Builder mapped = PlanNodeStatsEstimate.builder().setOutputRowCount(estimate.getOutputRowCount());
        for (int i = 0; i < inputs.size(); ++i) {
            mapped.addSymbolStatistics(outputs.get(i), estimate.getSymbolStatistics(inputs.get(i)));
        }
        return mapped.build();
    }
}

