/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class PlanNodeCostEstimate {
    public static final PlanNodeCostEstimate INFINITE_COST = new PlanNodeCostEstimate(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final PlanNodeCostEstimate UNKNOWN_COST = new PlanNodeCostEstimate(Double.NaN, Double.NaN, Double.NaN);
    public static final PlanNodeCostEstimate ZERO_COST = new PlanNodeCostEstimate(0.0, 0.0, 0.0);
    private final double cpuCost;
    private final double memoryCost;
    private final double networkCost;

    public static PlanNodeCostEstimate cpuCost(double cpuCost) {
        return new PlanNodeCostEstimate(cpuCost, 0.0, 0.0);
    }

    public static PlanNodeCostEstimate memoryCost(double memoryCost) {
        return new PlanNodeCostEstimate(0.0, memoryCost, 0.0);
    }

    public static PlanNodeCostEstimate networkCost(double networkCost) {
        return new PlanNodeCostEstimate(0.0, 0.0, networkCost);
    }

    public PlanNodeCostEstimate(double cpuCost, double memoryCost, double networkCost) {
        Preconditions.checkArgument((Double.isNaN(cpuCost) || cpuCost >= 0.0 ? 1 : 0) != 0, (Object)"cpuCost cannot be negative");
        Preconditions.checkArgument((Double.isNaN(memoryCost) || memoryCost >= 0.0 ? 1 : 0) != 0, (Object)"memoryCost cannot be negative");
        Preconditions.checkArgument((Double.isNaN(networkCost) || networkCost >= 0.0 ? 1 : 0) != 0, (Object)"networkCost cannot be negative");
        this.cpuCost = cpuCost;
        this.memoryCost = memoryCost;
        this.networkCost = networkCost;
    }

    public double getCpuCost() {
        return this.cpuCost;
    }

    public double getMemoryCost() {
        return this.memoryCost;
    }

    public double getNetworkCost() {
        return this.networkCost;
    }

    public boolean hasUnknownComponents() {
        return Double.isNaN(this.cpuCost) || Double.isNaN(this.memoryCost) || Double.isNaN(this.networkCost);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cpu", this.cpuCost).add("memory", this.memoryCost).add("network", this.networkCost).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanNodeCostEstimate that = (PlanNodeCostEstimate)o;
        return Double.compare(that.cpuCost, this.cpuCost) == 0 && Double.compare(that.memoryCost, this.memoryCost) == 0 && Double.compare(that.networkCost, this.networkCost) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.cpuCost, this.memoryCost, this.networkCost);
    }

    public PlanNodeCostEstimate add(PlanNodeCostEstimate other) {
        return new PlanNodeCostEstimate(this.cpuCost + other.cpuCost, this.memoryCost + other.memoryCost, this.networkCost + other.networkCost);
    }
}

