/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VariableWidthType;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.util.MoreMath;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

public class PlanNodeStatsEstimate {
    private static final double DEFAULT_DATA_SIZE_PER_COLUMN = 50.0;
    public static final PlanNodeStatsEstimate UNKNOWN_STATS = PlanNodeStatsEstimate.builder().build();
    private final double outputRowCount;
    private final PMap<Symbol, SymbolStatsEstimate> symbolStatistics;

    private PlanNodeStatsEstimate(double outputRowCount, PMap<Symbol, SymbolStatsEstimate> symbolStatistics) {
        Preconditions.checkArgument((Double.isNaN(outputRowCount) || outputRowCount >= 0.0 ? 1 : 0) != 0, (Object)"outputRowCount cannot be negative");
        this.outputRowCount = outputRowCount;
        this.symbolStatistics = symbolStatistics;
    }

    public double getOutputRowCount() {
        return this.outputRowCount;
    }

    public double getOutputSizeInBytes(Collection<Symbol> outputSymbols, TypeProvider types) {
        Objects.requireNonNull(outputSymbols, "outputSymbols is null");
        return outputSymbols.stream().mapToDouble(symbol -> this.getOutputSizeForSymbol(this.getSymbolStatistics((Symbol)symbol), types.get((Symbol)symbol))).sum();
    }

    private double getOutputSizeForSymbol(SymbolStatsEstimate symbolStatistics, Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type is null");
        double averageRowSize = symbolStatistics.getAverageRowSize();
        double nullsFraction = MoreMath.firstNonNaN(symbolStatistics.getNullsFraction(), 0.0);
        double numberOfNonNullRows = this.outputRowCount * (1.0 - nullsFraction);
        if (Double.isNaN(averageRowSize)) {
            averageRowSize = type instanceof FixedWidthType ? (double)((FixedWidthType)type).getFixedSize() : 50.0;
        }
        double outputSize = numberOfNonNullRows * averageRowSize;
        outputSize += this.outputRowCount * 1.0;
        if (type instanceof VariableWidthType) {
            outputSize += this.outputRowCount * 4.0;
        }
        return outputSize;
    }

    public PlanNodeStatsEstimate mapOutputRowCount(Function<Double, Double> mappingFunction) {
        return PlanNodeStatsEstimate.buildFrom(this).setOutputRowCount(mappingFunction.apply(this.outputRowCount)).build();
    }

    public PlanNodeStatsEstimate mapSymbolColumnStatistics(Symbol symbol, Function<SymbolStatsEstimate, SymbolStatsEstimate> mappingFunction) {
        return PlanNodeStatsEstimate.buildFrom(this).addSymbolStatistics(symbol, mappingFunction.apply(this.getSymbolStatistics(symbol))).build();
    }

    public SymbolStatsEstimate getSymbolStatistics(Symbol symbol) {
        return (SymbolStatsEstimate)this.symbolStatistics.getOrDefault((Object)symbol, (Object)SymbolStatsEstimate.UNKNOWN_STATS);
    }

    public Set<Symbol> getSymbolsWithKnownStatistics() {
        return this.symbolStatistics.keySet();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("outputRowCount", this.outputRowCount).add("symbolStatistics", this.symbolStatistics).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanNodeStatsEstimate that = (PlanNodeStatsEstimate)o;
        return Double.compare(this.outputRowCount, that.outputRowCount) == 0 && Objects.equals(this.symbolStatistics, that.symbolStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.outputRowCount, this.symbolStatistics);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder buildFrom(PlanNodeStatsEstimate other) {
        return new Builder(other.getOutputRowCount(), other.symbolStatistics);
    }

    public static final class Builder {
        private double outputRowCount;
        private PMap<Symbol, SymbolStatsEstimate> symbolStatistics;

        public Builder() {
            this(Double.NaN, (PMap<Symbol, SymbolStatsEstimate>)HashTreePMap.empty());
        }

        private Builder(double outputRowCount, PMap<Symbol, SymbolStatsEstimate> symbolStatistics) {
            this.outputRowCount = outputRowCount;
            this.symbolStatistics = symbolStatistics;
        }

        public Builder setOutputRowCount(double outputRowCount) {
            this.outputRowCount = outputRowCount;
            return this;
        }

        public Builder addSymbolStatistics(Symbol symbol, SymbolStatsEstimate statistics) {
            this.symbolStatistics = this.symbolStatistics.plus((Object)symbol, (Object)statistics);
            return this;
        }

        public Builder addSymbolStatistics(Map<Symbol, SymbolStatsEstimate> symbolStatistics) {
            this.symbolStatistics = this.symbolStatistics.plusAll(symbolStatistics);
            return this;
        }

        public Builder removeSymbolStatistics(Symbol symbol) {
            this.symbolStatistics = this.symbolStatistics.minus((Object)symbol);
            return this;
        }

        public PlanNodeStatsEstimate build() {
            return new PlanNodeStatsEstimate(this.outputRowCount, this.symbolStatistics);
        }
    }
}

