/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatisticRange;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.sql.planner.Symbol;
import java.util.stream.Stream;

public class PlanNodeStatsEstimateMath {
    private PlanNodeStatsEstimateMath() {
    }

    public static PlanNodeStatsEstimate differenceInStats(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right) {
        return PlanNodeStatsEstimateMath.differenceInStatsWithRangeStrategy(left, right, StatisticRange::subtract);
    }

    public static PlanNodeStatsEstimate differenceInNonRangeStats(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right) {
        return PlanNodeStatsEstimateMath.differenceInStatsWithRangeStrategy(left, right, (leftRange, rightRange) -> leftRange);
    }

    private static PlanNodeStatsEstimate differenceInStatsWithRangeStrategy(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right, RangeSubtractionStrategy strategy) {
        PlanNodeStatsEstimate.Builder statsBuilder = PlanNodeStatsEstimate.builder();
        double newRowCount = left.getOutputRowCount() - right.getOutputRowCount();
        Stream.concat(left.getSymbolsWithKnownStatistics().stream(), right.getSymbolsWithKnownStatistics().stream()).forEach(symbol -> statsBuilder.addSymbolStatistics((Symbol)symbol, PlanNodeStatsEstimateMath.subtractColumnStats(left.getSymbolStatistics((Symbol)symbol), left.getOutputRowCount(), right.getSymbolStatistics((Symbol)symbol), right.getOutputRowCount(), newRowCount, strategy)));
        return statsBuilder.setOutputRowCount(newRowCount).build();
    }

    @Deprecated
    private static SymbolStatsEstimate subtractColumnStats(SymbolStatsEstimate leftStats, double leftRowCount, SymbolStatsEstimate rightStats, double rightRowCount, double newRowCount, RangeSubtractionStrategy strategy) {
        double rightValuesPerDistinctValue;
        StatisticRange leftRange = StatisticRange.from(leftStats);
        StatisticRange rightRange = StatisticRange.from(rightStats);
        double nullsCountLeft = leftStats.getNullsFraction() * leftRowCount;
        double nullsCountRight = rightStats.getNullsFraction() * rightRowCount;
        double totalSizeLeft = (leftRowCount - nullsCountLeft) * leftStats.getAverageRowSize();
        double totalSizeRight = (rightRowCount - nullsCountRight) * rightStats.getAverageRowSize();
        double newNullsFraction = Math.max(nullsCountLeft - nullsCountRight, 0.0) / newRowCount;
        double newNonNullsRowCount = newRowCount * (1.0 - newNullsFraction);
        StatisticRange range = leftRange;
        double newDistinctValuesCount = leftStats.getDistinctValuesCount();
        double leftValuesPerDistinctValue = leftRowCount * (1.0 - leftStats.getNullsFraction()) / leftStats.getDistinctValuesCount();
        if (leftValuesPerDistinctValue <= (rightValuesPerDistinctValue = rightRowCount * (1.0 - rightStats.getNullsFraction()) / rightStats.getDistinctValuesCount())) {
            range = strategy.range(leftRange, rightRange);
            newDistinctValuesCount = leftStats.getDistinctValuesCount() - rightStats.getDistinctValuesCount();
        }
        return SymbolStatsEstimate.builder().setDistinctValuesCount(newDistinctValuesCount).setHighValue(range.getHigh()).setLowValue(range.getLow()).setAverageRowSize((totalSizeLeft - totalSizeRight) / newNonNullsRowCount).setNullsFraction(newNullsFraction).build();
    }

    public static PlanNodeStatsEstimate addStatsAndSumDistinctValues(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right) {
        return PlanNodeStatsEstimateMath.addStats(left, right, StatisticRange::addAndSumDistinctValues);
    }

    public static PlanNodeStatsEstimate addStatsAndMaxDistinctValues(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right) {
        return PlanNodeStatsEstimateMath.addStats(left, right, StatisticRange::addAndMaxDistinctValues);
    }

    public static PlanNodeStatsEstimate addStatsAndCollapseDistinctValues(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right) {
        return PlanNodeStatsEstimateMath.addStats(left, right, StatisticRange::addAndCollapseDistinctValues);
    }

    private static PlanNodeStatsEstimate addStats(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right, RangeAdditionStrategy strategy) {
        PlanNodeStatsEstimate.Builder statsBuilder = PlanNodeStatsEstimate.builder();
        double newRowCount = left.getOutputRowCount() + right.getOutputRowCount();
        Stream.concat(left.getSymbolsWithKnownStatistics().stream(), right.getSymbolsWithKnownStatistics().stream()).distinct().forEach(symbol -> statsBuilder.addSymbolStatistics((Symbol)symbol, PlanNodeStatsEstimateMath.addColumnStats(left.getSymbolStatistics((Symbol)symbol), left.getOutputRowCount(), right.getSymbolStatistics((Symbol)symbol), right.getOutputRowCount(), newRowCount, strategy)));
        return statsBuilder.setOutputRowCount(newRowCount).build();
    }

    private static SymbolStatsEstimate addColumnStats(SymbolStatsEstimate leftStats, double leftRows, SymbolStatsEstimate rightStats, double rightRows, double newRowCount, RangeAdditionStrategy strategy) {
        StatisticRange leftRange = StatisticRange.from(leftStats);
        StatisticRange rightRange = StatisticRange.from(rightStats);
        StatisticRange sum = strategy.add(leftRange, rightRange);
        double nullsCountRight = rightStats.getNullsFraction() * rightRows;
        double nullsCountLeft = leftStats.getNullsFraction() * leftRows;
        double totalSizeLeft = (leftRows - nullsCountLeft) * leftStats.getAverageRowSize();
        double totalSizeRight = (rightRows - nullsCountRight) * rightStats.getAverageRowSize();
        double newNullsFraction = (nullsCountLeft + nullsCountRight) / newRowCount;
        double newNonNullsRowCount = newRowCount * (1.0 - newNullsFraction);
        return SymbolStatsEstimate.builder().setStatisticsRange(sum).setAverageRowSize((totalSizeLeft + totalSizeRight) / newNonNullsRowCount).setNullsFraction(newNullsFraction).build();
    }

    @FunctionalInterface
    private static interface RangeAdditionStrategy {
        public StatisticRange add(StatisticRange var1, StatisticRange var2);
    }

    @FunctionalInterface
    private static interface RangeSubtractionStrategy {
        public StatisticRange range(StatisticRange var1, StatisticRange var2);
    }
}

