/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.FilterStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.SemiJoinStatsCalculator;
import com.facebook.presto.cost.SimpleStatsRule;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SimpleFilterProjectSemiJoinStatsRule
extends SimpleStatsRule<FilterNode> {
    private static final Pattern<FilterNode> PATTERN = Patterns.filter();
    private final FilterStatsCalculator filterStatsCalculator;

    public SimpleFilterProjectSemiJoinStatsRule(StatsNormalizer normalizer, FilterStatsCalculator filterStatsCalculator) {
        super(normalizer);
        this.filterStatsCalculator = Objects.requireNonNull(filterStatsCalculator, "filterStatsCalculator can not be null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(FilterNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        SemiJoinNode semiJoinNode;
        PlanNode nodeSource = lookup.resolve(node.getSource());
        if (nodeSource instanceof ProjectNode) {
            ProjectNode projectNode = (ProjectNode)nodeSource;
            if (!projectNode.isIdentity()) {
                return Optional.empty();
            }
            PlanNode projectNodeSource = lookup.resolve(projectNode.getSource());
            if (!(projectNodeSource instanceof SemiJoinNode)) {
                return Optional.empty();
            }
            semiJoinNode = (SemiJoinNode)projectNodeSource;
        } else if (nodeSource instanceof SemiJoinNode) {
            semiJoinNode = (SemiJoinNode)nodeSource;
        } else {
            return Optional.empty();
        }
        return this.calculate(node, semiJoinNode, sourceStats, session, types);
    }

    private Optional<PlanNodeStatsEstimate> calculate(FilterNode filterNode, SemiJoinNode semiJoinNode, StatsProvider statsProvider, Session session, TypeProvider types) {
        PlanNodeStatsEstimate sourceStats = statsProvider.getStats(semiJoinNode.getSource());
        PlanNodeStatsEstimate filteringSourceStats = statsProvider.getStats(semiJoinNode.getFilteringSource());
        Symbol filteringSourceJoinSymbol = semiJoinNode.getFilteringSourceJoinSymbol();
        Symbol sourceJoinSymbol = semiJoinNode.getSourceJoinSymbol();
        Optional<SemiJoinOutputFilter> semiJoinOutputFilter = SimpleFilterProjectSemiJoinStatsRule.extractSemiJoinOutputFilter(filterNode.getPredicate(), semiJoinNode.getSemiJoinOutput());
        if (!semiJoinOutputFilter.isPresent()) {
            return Optional.empty();
        }
        PlanNodeStatsEstimate semiJoinStats = semiJoinOutputFilter.get().isNegated() ? SemiJoinStatsCalculator.computeAntiJoin(sourceStats, filteringSourceStats, sourceJoinSymbol, filteringSourceJoinSymbol) : SemiJoinStatsCalculator.computeSemiJoin(sourceStats, filteringSourceStats, sourceJoinSymbol, filteringSourceJoinSymbol);
        return Optional.of(this.filterStatsCalculator.filterStats(semiJoinStats, semiJoinOutputFilter.get().getRemainingPredicate(), session, types));
    }

    private static Optional<SemiJoinOutputFilter> extractSemiJoinOutputFilter(Expression predicate, Symbol semiJoinOutput) {
        List<Expression> conjuncts = ExpressionUtils.extractConjuncts(predicate);
        List semiJoinOutputReferences = (List)conjuncts.stream().filter(conjunct -> SimpleFilterProjectSemiJoinStatsRule.isSemiJoinOutputReference(conjunct, semiJoinOutput)).collect(ImmutableList.toImmutableList());
        if (semiJoinOutputReferences.size() != 1) {
            return Optional.empty();
        }
        Expression semiJoinOutputReference = (Expression)Iterables.getOnlyElement((Iterable)semiJoinOutputReferences);
        Expression remainingPredicate = ExpressionUtils.combineConjuncts((Collection)conjuncts.stream().filter(conjunct -> conjunct != semiJoinOutputReference).collect(ImmutableList.toImmutableList()));
        boolean negated = semiJoinOutputReference instanceof NotExpression;
        return Optional.of(new SemiJoinOutputFilter(negated, remainingPredicate));
    }

    private static boolean isSemiJoinOutputReference(Expression conjunct, Symbol semiJoinOutput) {
        SymbolReference semiJoinOuputSymbolReference = semiJoinOutput.toSymbolReference();
        return conjunct.equals((Object)semiJoinOuputSymbolReference) || conjunct instanceof NotExpression && ((NotExpression)conjunct).getValue().equals((Object)semiJoinOuputSymbolReference);
    }

    private static class SemiJoinOutputFilter {
        private final boolean negated;
        private final Expression remainingPredicate;

        public SemiJoinOutputFilter(boolean negated, Expression remainingPredicate) {
            this.negated = negated;
            this.remainingPredicate = Objects.requireNonNull(remainingPredicate, "remainingPredicate can not be null");
        }

        public boolean isNegated() {
            return this.negated;
        }

        public Expression getRemainingPredicate() {
            return this.remainingPredicate;
        }
    }
}

